/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : spi.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-09-25
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include "mm32_device.h"

void spi_int(void)
{
    /* Enable SPI1 Clock */
    SET_BIT(RCC->APB1ENR, RCC_APB1ENR_SPI1);

        /* Receipt Data Number */
    MODIFY_REG(SPI1->RXDNR, SPI_RXDNR_RXDNR, 0x00U << SPI_RXDNR_RXDNR_Pos);

    /* Only Valid In Low 8 Bit */
    CLEAR_BIT(SPI1->GCTL, SPI_GCTL_DW8_32);

    /* SPI Data Width Bit : 8 Bit Data */
    SET_BIT(SPI1->CCTL, SPI_CCTL_SPILEN);

    /* NSS Output Control By The NSSR Register Value */
    CLEAR_BIT(SPI1->GCTL, SPI_GCTL_NSS);

    /* Host/Master Mode */
    SET_BIT(SPI1->GCTL, SPI_GCTL_MODE);

    /* Data Transmission Or Receipt Highest Bit In Front : MSB */
    CLEAR_BIT(SPI1->CCTL, SPI_CCTL_LSBFE);

    /* Clock In Low Level In Idle Status */
    CLEAR_BIT(SPI1->CCTL, SPI_CCTL_CPOL);

    /* The First Data Bit Sampling Begins From The First Clock Edge */
    SET_BIT(SPI1->CCTL, SPI_CCTL_CPHA);

    /* SPI Baud Rate Control, Baud Rate = PCLK1 / SPBRG */
    MODIFY_REG(SPI1->SPBRG, SPI_SPBRG_SPBRG, 0x10U << SPI_SPBRG_SPBRG_Pos);

    /* Receipt Enable */
    SET_BIT(SPI1->GCTL, SPI_GCTL_RXEN);

    /* Transmission Enable */
    SET_BIT(SPI1->GCTL, SPI_GCTL_TXEN);

    /* Enable GPIOA Clock */
    SET_BIT(RCC->AHBENR, RCC_AHBENR_GPIOA);

    /* Config PA10 AF0 */
    MODIFY_REG(GPIOA->AFRH, GPIO_AFRH_AFR10, 0x00U << GPIO_AFRH_AFR10_Pos);   /* SPI1_MISO */

    /* Config PA10 Input Pull-Up/Pull-Down Mode */
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_MODE10, 0x00U << GPIO_CRH_MODE10_Pos);
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_CNF10,  0x02U << GPIO_CRH_CNF10_Pos);
    /* Pull-Up */
    WRITE_REG(GPIOA->BSRR, GPIO_BSRR_BS10);

    /* Config PA8 AF0 */
    MODIFY_REG(GPIOA->AFRH, GPIO_AFRH_AFR8, 0x00U << GPIO_AFRH_AFR8_Pos);   /* SPI1_SCK */

    /* Config PA8 Alternate Function Output Push-Pull */
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_MODE8, 0x01U << GPIO_CRH_MODE8_Pos);
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_CNF8,  0x02U << GPIO_CRH_CNF8_Pos);

    /* Config PA9 AF0 */
    MODIFY_REG(GPIOA->AFRH, GPIO_AFRH_AFR9, 0x00U << GPIO_AFRH_AFR9_Pos);   /* SPI1_MOSI */

    /* Config PA9 Alternate Function Output Push-Pull */
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_MODE9, 0x01U << GPIO_CRH_MODE9_Pos);
    MODIFY_REG(GPIOA->CRH, GPIO_CRH_CNF9,  0x02U << GPIO_CRH_CNF9_Pos);

    /* Config PA0 AF0 */
    MODIFY_REG(GPIOA->AFRL, GPIO_AFRL_AFR0, 0x00U << GPIO_AFRL_AFR0_Pos);   /* SPI1_NSS */

    /* Config PA0 Alternate Function Output Push-Pull */
    MODIFY_REG(GPIOA->CRL, GPIO_CRL_MODE0, 0x01U << GPIO_CRL_MODE0_Pos);
    MODIFY_REG(GPIOA->CRL, GPIO_CRL_CNF0,  0x02U << GPIO_CRL_CNF0_Pos);

    /* SPI Enable */
    SET_BIT(SPI1->GCTL, SPI_GCTL_SPIEN);
    
}

uint8_t spi_inout(uint8_t out_data)
{
    uint8_t in_data = 0;
    uint16_t time_out = 0;
    
    /* Wait Transmission Buffer And Shift Register Both Are Empty */
    while (0 == READ_BIT(SPI1->CSTAT, SPI_CSTAT_TXEPT))
    {
        time_out++;
        if(time_out > 251)
            return 0;
    }
    WRITE_REG(SPI1->TXREG, out_data);
    
    time_out = 0;
    
    /* Wait Receipt Buffer Is Not Empty */
    while (0 == READ_BIT(SPI1->CSTAT, SPI_CSTAT_RXAVL))
    {
        time_out++;
        if(time_out > 251)
            return 0;
    }

    in_data = READ_REG(SPI1->RXREG);
    
    return in_data;
}


