/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : board.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-06-27
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include "board.h"
#include "utilities.h"

static volatile uint32_t system_tick = 0;

static void delay_init(void);

void board_init(void)
{
    delay_init();
    spi_init();
    hs6220_io_init();

}

void uart_send(uint8_t *buff, uint16_t size)
{
    for (uint16_t i = 0; i <size; i++)
    {
        UART_SendData(UART2, buff[i]);

        while (RESET == UART_GetFlagStatus(UART2, UART_FLAG_TXEPT))
        {
        }
    }
}


static void delay_init(void)
{
    if (SysTick_Config(72000000 / 1000))
    {
        while (1)
        {
        }
    }

    NVIC_SetPriority(SysTick_IRQn, 0x0);
}

void delay_ms(uint32_t delay)
{
    uint32_t tickstart = system_tick;
    uint32_t wait = delay;

    while((system_tick - tickstart) < wait)
    {
    }
}


uint32_t hal_get_tick(void)
{
    return system_tick;
}

uint32_t hal_get_elapsed_time( uint32_t past )
{
    if ( past == 0 )
    {
        return 0;
    }
    uint32_t now = hal_get_tick( );

    // Intentional wrap around. Works Ok if tick duration below 1ms
    return now - past;
}
uint16_t test = 0;


void SysTick_Handler(void)
{
    system_tick ++; 
	rf_int();
}



