/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : flash.h
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-07-11
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#ifndef __FLASH_H_
#define __FLASH_H_

#define FLASH_SECTOR_SIZE           1024
#define FLASH_BASE_ADDR             ((uint32_t)0x8000000U)
#define FLASH_END_ADDR              ((uint32_t)0x0800FFFFU)

#define FLASH_DATA_BASE_SECTOR      58
#define FLASH_DATA_SECTOR_SIZE      6


#define FLASH_BACKUP_FLAG_ADDR      ((uint32_t)(FLASH_BASE_ADDR + 56*FLASH_SECTOR_SIZE))
#define FLASH_BACKUP_ADDR           ((uint32_t)(FLASH_BASE_ADDR + 57*FLASH_SECTOR_SIZE))
#define FLASH_DATA_BASE_ADDR        ((uint32_t)(FLASH_BASE_ADDR + 58*FLASH_SECTOR_SIZE))  /*!< FLASH DATA base address in the alias region */


void flash_init(void);
void flash_erase(uint32_t address);
void flash_write_no_check(uint32_t address, uint32_t *buffer, uint32_t size );
void flash_read(uint32_t address, uint8_t *buffer, uint32_t size);
void flash_write(uint32_t address, uint8_t *buffer, uint32_t size );
void flash_fill(uint32_t address, uint8_t data, uint32_t size );


#endif


 

