/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : pwm.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-07-13
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#include "board.h"
#include "utilities.h"

//void pwm_init(uint32_t period, uint8_t channel_num)
//{
//    GPIO_InitTypeDef        GPIO_InitStruct;
//    TIM_OCInitTypeDef       TIM_OCInitStruct;
//    TIM_TimeBaseInitTypeDef TIM_TimeBaseStruct;

//    RCC_ClocksTypeDef RCC_Clocks;

//    RCC_GetClocksFreq(&RCC_Clocks);
//    
//    RCC_APB2PeriphClockCmd(RCC_APB2ENR_TIM1, ENABLE);
//    RCC_APB1PeriphClockCmd(RCC_APB1ENR_TIM3, ENABLE);
//    RCC_AHBPeriphClockCmd(RCC_AHBENR_GPIOB, ENABLE);

//    TIM_TimeBaseStructInit(&TIM_TimeBaseStruct);
//    TIM_TimeBaseStruct.TIM_Prescaler         = 4;
//    TIM_TimeBaseStruct.TIM_CounterMode       = TIM_CounterMode_Up;
//    TIM_TimeBaseStruct.TIM_Period            = period-1;
//    TIM_TimeBaseStruct.TIM_ClockDivision     = TIM_CKD_DIV1;
//    TIM_TimeBaseStruct.TIM_RepetitionCounter = 0;
//    
//    if (channel_num != MODE_RGB_NUM)
//    {
//        TIM_TimeBaseInit(TIM1, &TIM_TimeBaseStruct);
//    }
//    
//    if (channel_num > MODE_CW_NUM)
//    {
//        TIM_TimeBaseInit(TIM3, &TIM_TimeBaseStruct);
//    }
//    
//    TIM_OCStructInit(&TIM_OCInitStruct);
//    TIM_OCInitStruct.TIM_OCMode       = TIM_OCMode_PWM1;
//    TIM_OCInitStruct.TIM_OutputState  = TIM_OutputState_Enable;
//    TIM_OCInitStruct.TIM_Pulse        = 0;
//    TIM_OCInitStruct.TIM_OCPolarity   = TIM_OCPolarity_High;
//    TIM_OCInitStruct.TIM_OCIdleState  = TIM_OCIdleState_Set;
//    
//    GPIO_StructInit(&GPIO_InitStruct);
//    GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;
//    GPIO_InitStruct.GPIO_Mode  = GPIO_Mode_AF_PP;

//    if (channel_num != MODE_RGB_NUM)
//    {
//        TIM_OC1Init(TIM1, &TIM_OCInitStruct);
//        if (channel_num == MODE_CW_NUM || channel_num == MODE_RGBCW_NUM)
//        {
//            TIM_OCInitStruct.TIM_OCPolarity   = TIM_OCPolarity_Low;
//            TIM_OC2Init(TIM1, &TIM_OCInitStruct);
//            GPIO_PinAFConfig(GPIOB, GPIO_PinSource4, GPIO_AF_6);  /* TIM1_CH2 */
//            GPIO_InitStruct.GPIO_Pin   = GPIO_Pin_4;
//        }
//        GPIO_PinAFConfig(GPIOB, GPIO_PinSource3, GPIO_AF_6);  /* TIM1_CH1 */
//        
//        GPIO_InitStruct.GPIO_Pin  |= GPIO_Pin_3;
//        
//        GPIO_Init(GPIOB, &GPIO_InitStruct);
//        
//        
//        TIM_Cmd(TIM1, ENABLE);
//        TIM_CtrlPWMOutputs(TIM1, ENABLE);
//    }
//    
//    if (channel_num > MODE_CW_NUM)
//    {
//        TIM_Cmd(TIM3, ENABLE);
//        TIM_CtrlPWMOutputs(TIM3, ENABLE);
//    }
//}

void pwm_init(uint32_t period, uint8_t channel_num)
{
    GPIO_InitTypeDef        GPIO_InitStruct;
    TIM_OCInitTypeDef       TIM_OCInitStruct;
    TIM_TimeBaseInitTypeDef TIM_TimeBaseStruct;
    
    RCC_APB2PeriphClockCmd(RCC_APB2ENR_TIM1, ENABLE);
    RCC_APB1PeriphClockCmd(RCC_APB1ENR_TIM2, ENABLE);
    RCC_AHBPeriphClockCmd(RCC_AHBENR_GPIOB, ENABLE);   
    
    TIM_TimeBaseStructInit(&TIM_TimeBaseStruct);
    
    TIM_TimeBaseStruct.TIM_CounterMode       = TIM_CounterMode_Up;
    TIM_TimeBaseStruct.TIM_Period            = period-1;
    TIM_TimeBaseStruct.TIM_ClockDivision     = TIM_CKD_DIV1;
    TIM_TimeBaseStruct.TIM_RepetitionCounter = 0;
    
    TIM_TimeBaseStruct.TIM_Prescaler         = 2-1;
    TIM_TimeBaseInit(TIM1, &TIM_TimeBaseStruct);
    
    TIM_TimeBaseStruct.TIM_Prescaler         = 2-1;
    TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStruct);
    
    TIM_OCStructInit(&TIM_OCInitStruct);
    TIM_OCInitStruct.TIM_OCMode       = TIM_OCMode_PWM1;
    TIM_OCInitStruct.TIM_OutputState  = TIM_OutputState_Enable;
    TIM_OCInitStruct.TIM_Pulse        = 0;
    TIM_OCInitStruct.TIM_OCPolarity   = TIM_OCPolarity_High;
    TIM_OCInitStruct.TIM_OCIdleState  = TIM_OCIdleState_Set;
    TIM_OC1Init(TIM1, &TIM_OCInitStruct);
    
    TIM_OC2Init(TIM2, &TIM_OCInitStruct);
    
    GPIO_PinAFConfig(GPIOB, GPIO_PinSource3, GPIO_AF_6);  /* TIM1_CH1 */
     GPIO_PinAFConfig(GPIOB, GPIO_PinSource4, GPIO_AF_7);  /* TIM2_CH2 */
    
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStruct.GPIO_Mode  = GPIO_Mode_AF_PP;
    GPIO_InitStruct.GPIO_Pin  = GPIO_Pin_3|GPIO_Pin_4;
    GPIO_Init(GPIOB, &GPIO_InitStruct);

    TIM_Cmd(TIM1, ENABLE);
    TIM_CtrlPWMOutputs(TIM1, ENABLE);
    
    TIM_Cmd(TIM2, ENABLE);
    TIM_CtrlPWMOutputs(TIM2, ENABLE);
    
}



void pwm_set_duty(uint8_t channel, uint16_t duty) 
{
    switch (channel)
    {
    	case 0:
            TIM_SetCompare1(TIM1, duty);
    		break;
    	case 1:
            TIM_SetCompare2(TIM2, duty);
    		break;
        case 2:
            TIM_SetCompare1(TIM3, duty);
    		break;
        case 3:
            TIM_SetCompare2(TIM3, duty);
    		break;
        case 4:
            TIM_SetCompare3(TIM3, duty);
    		break;
    	default:
    		break;
    }
}

