/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : radio.h
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-06-27
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */

#ifndef __RADIO_H_
#define __RADIO_H_

#include <stdint.h>
#include <stdbool.h>

typedef enum {
	HS6220_Bank0 = 0,
	HS6220_Bank1 = 0x80
}hs6220_bank_type_t;

typedef enum {
	HS6220_PRX_Mode = 0,
	HS6220_PTX_Mode,
	HS6220_Carrier_Mode
}hs6220_mode_type_t;

void hs6220_operation(uint8_t opt);
void hs6220_write_buffer(uint8_t addr,const uint8_t* buf,uint8_t len);
void hs6220_write(uint8_t addr,uint8_t data);
void hs6220_read_buffer(uint8_t addr, uint8_t *buffer, uint8_t size);
uint8_t hs6220_read( uint8_t addr );
void hs6220_write_cmd(uint8_t cmd,uint8_t data);
void hs6220_ce_high(void);
void hs6220_ce_low(void);
void hs6220_ce_high_pulse(void);
void hs6220_clear_all_irq(void);
void hs6220_flush_tx(void);
void hs6220_flush_rx(void);
void hs6220_bank_switch(hs6220_bank_type_t bank);
void hs6220_mode_switch(hs6220_mode_type_t mod);
void hs6220_init(void);
uint8_t hs6220_receive_pack(uint8_t *buf);
void hs6220_send(uint8_t *buff, uint16_t size);

#endif


 

