/**
  ************************************* Copyright ****************************** 
  *
  *                 Copyright (C), 2012-2016, Radioway Tech. Co., Ltd.
  *                            All Rights Reserved
  *
  *    
  * FileName   : utilities.c
  * Version    : v1.0
  * Author     : Heb
  * Date       : 2024-03-18
  * Description: 
  * Function List: 
  	1. ....
          <version>: 
     <modify staff>: 
             <data>: 
      <description>: 
  	2. ...
  ******************************************************************************
 */
 
#include <stdint.h>
#include <stdbool.h>
#include "utilities.h"

static const unsigned short crc_tabccitt[256] = {
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
    0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
    0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
    0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
    0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
    0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
    0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
    0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
    0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
    0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
    0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
    0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
    0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
    0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
    0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
    0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
    0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
    0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
    0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
    0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
    0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
    0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
    0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
    0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
    0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
    0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
    0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
    0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
    0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
    0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
    0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
    0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
};


/*
 * static u16 crc_ccitt_generic( const unsigned char *input_str, u8 num_bytes);
 *
 * The function crc_ccitt_generic() is a generic implementation of the CCITT
 * algorithm for a one-pass calculation of the CRC for a byte string. The
 * function accepts an initial start value for the crc.
 */

unsigned short crc_ccitt_generic( const unsigned char *input_str, unsigned char num_bytes )
{

    unsigned short crc;
    const unsigned char *ptr;
    unsigned char a;

    crc = 0xffff;
    ptr = input_str;

    if ( ptr != 0 )
    {
        for (a=0; a<num_bytes; a++)
        {
            crc = (crc << 8) ^ crc_tabccitt[ ((crc >> 8) ^ (unsigned short) *ptr++) & 0x00FF ];
        }
    }

    return crc;

}  /* crc_ccitt_generic */

unsigned short get_crc16(const unsigned char* ddata, unsigned char start, unsigned char length, unsigned short crc_init)
{

	unsigned short crc = crc_init & 0xFFFF;
	int i;
	for ( i = 0; i < length; i++) 
    {
		crc = (crc<<8) ^ crc_tabccitt[(ddata[start + i] ^ (crc>>8)) & 0x00FF];
	}
	return crc;
}

unsigned char bit_order(unsigned char in_data)
{
    unsigned char result = 0;
    unsigned char i;
    /* change msb->lsb */
    for (i=0; i<8; i++) {
        result += ((in_data>>(8-1-i))&0x1) << i;
    }
    return result;
}


/**
 * @brief ll_data_whitening()
 *
 * Data whitening is from payload to crc, and not include PREABLE and AA
 * For example: the in_data of scan_req_header is {0x03,0x0C}
 *
 * @ref core_v4.1_P2523
 *
 * @param[in] in_data
 * @param[in] len
 * @param[in] channel_index
 * @param[in] out_data
 *
 * @return
 **/
void ll_data_whitening(const  unsigned char *in_data, unsigned len, unsigned channel_index,  unsigned char *out_data)
{
    unsigned i, j;
    unsigned char seed;

    // Do linear feedback shift register (LFSR)
    seed = 0x01;                           // Position0 = 1;
    seed |= (channel_index & (1<<5)) >> 4; // Position1;
    seed |= (channel_index & (1<<4)) >> 2; // Position2;
    seed |= (channel_index & (1<<3)) << 0; // Position3;
    seed |= (channel_index & (1<<2)) << 2; // Position4;
    seed |= (channel_index & (1<<1)) << 4; // Position5;
    seed |= (channel_index & (1<<0)) << 6; // Position6;

    for(i=0; i<len; ++i)
    {
        unsigned char out = 0;

        for(j=0; j<8; ++j)
        {
            unsigned char factor = (seed & (1<<6)) >> 6;
            unsigned char shift_out;

            out |= (in_data[i] ^ (factor << j)) & (1<<j);

            seed <<= 1;
            shift_out = (seed >> 7) & 0x01;
            seed = (seed & ~(1<<0)) | shift_out;
            seed = (seed & ~(1<<4)) | ((seed ^ (shift_out << 4)) & (1<<4));
        }

        out_data[i] = out;
    }
}

unsigned char check_sum(unsigned char *ptr, int len)
{
    unsigned int cksum = 0;
   
    for (int i = 0; i < len ; i++)
	{
		cksum += ptr[i];
	}
    
    return (unsigned char)cksum;
}


// Standard random functions redefinition start
#define RAND_LOCAL_MAX 2147483647L

static uint32_t next = 1;

int32_t rand1( void )
{
    return ( ( next = next * 1103515245L + 12345L ) % RAND_LOCAL_MAX );
}

void srand1( uint32_t seed )
{
    next = seed;
}
// Standard random functions redefinition end

int32_t randr( int32_t min, int32_t max )
{
    return ( int32_t )rand1( ) % ( max - min + 1 ) + min;
}



static const uint32_t crc24_table[256] =
{
    0x000000, 0x800000, 0x400000, 0xc00000, 0x200000, 0xa00000, 0x600000, 0xe00000,
    0x100000, 0x900000, 0x500000, 0xd00000, 0x300000, 0xb00000, 0x700000, 0xf00000,
    0x080000, 0x880000, 0x480000, 0xc80000, 0x280000, 0xa80000, 0x680000, 0xe80000,
    0x180000, 0x980000, 0x580000, 0xd80000, 0x380000, 0xb80000, 0x780000, 0xf80000,
    0x040000, 0x840000, 0x440000, 0xc40000, 0x240000, 0xa40000, 0x640000, 0xe40000,
    0x140000, 0x940000, 0x540000, 0xd40000, 0x340000, 0xb40000, 0x740000, 0xf40000,
    0x0c0000, 0x8c0000, 0x4c0000, 0xcc0000, 0x2c0000, 0xac0000, 0x6c0000, 0xec0000,
    0x1c0000, 0x9c0000, 0x5c0000, 0xdc0000, 0x3c0000, 0xbc0000, 0x7c0000, 0xfc0000,
    0x020000, 0x820000, 0x420000, 0xc20000, 0x220000, 0xa20000, 0x620000, 0xe20000,
    0x120000, 0x920000, 0x520000, 0xd20000, 0x320000, 0xb20000, 0x720000, 0xf20000,
    0x0a0000, 0x8a0000, 0x4a0000, 0xca0000, 0x2a0000, 0xaa0000, 0x6a0000, 0xea0000,
    0x1a0000, 0x9a0000, 0x5a0000, 0xda0000, 0x3a0000, 0xba0000, 0x7a0000, 0xfa0000,
    0x060000, 0x860000, 0x460000, 0xc60000, 0x260000, 0xa60000, 0x660000, 0xe60000,
    0x160000, 0x960000, 0x560000, 0xd60000, 0x360000, 0xb60000, 0x760000, 0xf60000,
    0x0e0000, 0x8e0000, 0x4e0000, 0xce0000, 0x2e0000, 0xae0000, 0x6e0000, 0xee0000,
    0x1e0000, 0x9e0000, 0x5e0000, 0xde0000, 0x3e0000, 0xbe0000, 0x7e0000, 0xfe0000,
    0x010000, 0x810000, 0x410000, 0xc10000, 0x210000, 0xa10000, 0x610000, 0xe10000,
    0x110000, 0x910000, 0x510000, 0xd10000, 0x310000, 0xb10000, 0x710000, 0xf10000,
    0x090000, 0x890000, 0x490000, 0xc90000, 0x290000, 0xa90000, 0x690000, 0xe90000,
    0x190000, 0x990000, 0x590000, 0xd90000, 0x390000, 0xb90000, 0x790000, 0xf90000,
    0x050000, 0x850000, 0x450000, 0xc50000, 0x250000, 0xa50000, 0x650000, 0xe50000,
    0x150000, 0x950000, 0x550000, 0xd50000, 0x350000, 0xb50000, 0x750000, 0xf50000,
    0x0d0000, 0x8d0000, 0x4d0000, 0xcd0000, 0x2d0000, 0xad0000, 0x6d0000, 0xed0000,
    0x1d0000, 0x9d0000, 0x5d0000, 0xdd0000, 0x3d0000, 0xbd0000, 0x7d0000, 0xfd0000,
    0x030000, 0x830000, 0x430000, 0xc30000, 0x230000, 0xa30000, 0x630000, 0xe30000,
    0x130000, 0x930000, 0x530000, 0xd30000, 0x330000, 0xb30000, 0x730000, 0xf30000,
    0x0b0000, 0x8b0000, 0x4b0000, 0xcb0000, 0x2b0000, 0xab0000, 0x6b0000, 0xeb0000,
    0x1b0000, 0x9b0000, 0x5b0000, 0xdb0000, 0x3b0000, 0xbb0000, 0x7b0000, 0xfb0000,
    0x070000, 0x870000, 0x470000, 0xc70000, 0x270000, 0xa70000, 0x670000, 0xe70000,
    0x170000, 0x970000, 0x570000, 0xd70000, 0x370000, 0xb70000, 0x770000, 0xf70000,
    0x0f0000, 0x8f0000, 0x4f0000, 0xcf0000, 0x2f0000, 0xaf0000, 0x6f0000, 0xef0000,
    0x1f0000, 0x9f0000, 0x5f0000, 0xdf0000, 0x3f0000, 0xbf0000, 0x7f0000, 0xff0000,
};

unsigned int crc24(unsigned char *input, int len) 
{
    unsigned char *octets; 
    unsigned int crc = 0x555555; // CRC24_INIT;
    int i;
    octets = input;
    while (len--) 
    {
        crc ^= crc24_table[*octets++];
        for (i = 0; i < 8; i++) {
            crc <<= 1; 
            if (crc & 0x1000000) 
                crc ^= 0x00065B;    //ʽPOLY_VAL
        }
    }
    return crc & 0xFFFFFF;
}














