#include "bsp.h"

static const pin_config_t adc_pin_config[] = 
{
    {PAD_ADC_CH_GPIO2, {MUX_ADC_CH_GPIO2}, PMU_PIN_MODE_FLOAT, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_ADC_CH_GPIO8, {MUX_ADC_CH_GPIO8}, PMU_PIN_MODE_FLOAT, PMU_PIN_DRIVER_CURRENT_NORMAL},
};

#define ADC_NUM      10

int16_t adc_ch2_data[ADC_NUM] = {0};

int16_t adc_ch8_data[ADC_NUM] = {0};

int16_t adc_bat_data[ADC_NUM] = {0};

int16_t adc_temp_data[ADC_NUM] = {0};


uint8_t flag_adc_finished = 0;


drv_adc_config_t adc_cfg = 
{
    .channel = ADC_CH_GPIO2,
    
    .gain = ADC_GAIN_1_3,
    
    .mode = ADC_MODE_SINGLE,
    
    .sampling_cycles = ADC_SAMPLING_CYCLES_128,
    
    .sum_num = ADC_SUM_NUM_16,
};



static void adc_read_cb(void *om_usart, drv_event_t event, void *read_buf, void *read_cnt)
{
    if (event == DRV_EVENT_COMMON_READ_COMPLETED) 
    {
        flag_adc_finished = 1;
    }
}



void bsp_adc_check_init(void)
{
    drv_pin_init(adc_pin_config, sizeof(adc_pin_config) / sizeof(adc_pin_config[0]));
    
    drv_adc_init(&adc_cfg);
}


void bsp_adc_check_demo(void)
{
    uint8_t i = 0;
    
    drv_adc_read(ADC_CH_GPIO2, &adc_ch2_data[0], ADC_NUM);
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < ADC_NUM;i++)
    {
        om_printf("ch2 data[%d] = %d \r\n",i,adc_ch2_data[i]);
    }
    
    om_printf("\r\n\r\n");
}


void bsp_adc_int_init(void)
{
    drv_pin_init(adc_pin_config, sizeof(adc_pin_config) / sizeof(adc_pin_config[0]));
    
    drv_adc_init(&adc_cfg);
    
    drv_adc_register_isr_callback(adc_read_cb);
    
    drv_adc_read_int(ADC_CH_GPIO2, &adc_ch2_data[0], ADC_NUM);
}


void bsp_adc_int_demo(void)
{
    uint8_t i = 0;
    
    if(flag_adc_finished == 1)
    {
        flag_adc_finished = 0;
        
        om_printf("\r\n\r\n");
    
        for(i = 0;i < ADC_NUM;i++)
        {
            om_printf("ch2 data[%d] = %d \r\n",i,adc_ch2_data[i]);
        }
        
        om_printf("\r\n\r\n");
        
        drv_adc_read_int(ADC_CH_GPIO2, &adc_ch2_data[0], ADC_NUM);
    }
}


void bsp_adc_dma_init(void)
{
    drv_pin_init(adc_pin_config, sizeof(adc_pin_config) / sizeof(adc_pin_config[0]));
    
    drv_adc_init(&adc_cfg);
    
    drv_adc_register_isr_callback(adc_read_cb);
    
    drv_adc_dma_channel_allocate();
    
    drv_adc_read_dma(ADC_CH_GPIO2, &adc_ch2_data[0], ADC_NUM);
}


void bsp_adc_dma_demo(void)
{
    uint8_t i = 0;
    
    if(flag_adc_finished == 1)
    {
        flag_adc_finished = 0;
        
        om_printf("\r\n\r\n");
    
        for(i = 0;i < ADC_NUM;i++)
        {
            om_printf("ch2 data[%d] = %d \r\n",i,adc_ch2_data[i]);
        }
        
        om_printf("\r\n\r\n");
        
        drv_adc_read_int(ADC_CH_GPIO2, &adc_ch2_data[0], ADC_NUM);
    }
}


void bsp_adc_temp_init(void)
{
    adc_cfg.channel = ADC_CH_TEMPERATURE;
    
    drv_adc_init(&adc_cfg);
}


void bsp_adc_temp_demo(void)
{
    uint8_t i = 0;
    
    drv_adc_read(ADC_CH_TEMPERATURE, &adc_temp_data[0], ADC_NUM);
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < ADC_NUM;i++)
    {
        om_printf("temp data[%d] = %d \r\n",i,adc_temp_data[i]);
    }
    
    om_printf("\r\n\r\n");
}


void bsp_adc_bat_init(void)
{
    adc_cfg.channel = ADC_CH_VBAT;
    
    drv_adc_init(&adc_cfg);
}


void bsp_adc_bat_demo(void)
{
    uint8_t i = 0;
    
    drv_adc_read(ADC_CH_VBAT, &adc_bat_data[0], ADC_NUM);
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < ADC_NUM;i++)
    {
        om_printf("bat data[%d] = %d \r\n",i,adc_bat_data[i]);
    }
    
    om_printf("\r\n\r\n");
}










