#include "bsp.h"


key_typedef key1;

key_typedef key2;

static const pin_config_t key_cfg_cnt[] = 
{	
    {PAD_KEY1, {MUX_KEY1}, PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
    
    {PAD_KEY2, {MUX_KEY2}, PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
};

static const gpio_config_t key_check_gpio_config[] = 
{
    {OM_GPIO0, PAD_KEY1, GPIO_DIR_INPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_NONE},
    
    {OM_GPIO0, PAD_KEY2, GPIO_DIR_INPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_NONE},
};


static const gpio_config_t key_int_gpio_config[] = 
{
    {OM_GPIO0, PAD_KEY1, GPIO_DIR_INPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_RISING_EDGE},
    
    {OM_GPIO0, PAD_KEY2, GPIO_DIR_INPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_RISING_FAILING_EDGE},
};

uint8_t flag_key1 = 0;

uint8_t flag_key2 = 0;


void bsp_key_check_init(void)
{
    drv_pin_init(key_cfg_cnt, sizeof(key_cfg_cnt) / sizeof(key_cfg_cnt[0]));
    
    drv_gpio_init(key_check_gpio_config, sizeof(key_check_gpio_config) / sizeof(key_check_gpio_config[0]));
    
    key1.key_pin = PAD_KEY1;
    
    key1.key_valid_level = VALID_LEVEL_LOW;
    
    key1.key_count = 100;
    
    key1.key_press_count = 0;
    
    key1.key_release_count = 0;
    
    key1.key_state = KEY_STATE_RELEASE;
    
    key2.key_pin = PAD_KEY2;
    
    key2.key_valid_level = VALID_LEVEL_LOW;
    
    key2.key_count = 100;
    
    key2.key_press_count = 0;
    
    key2.key_release_count = 0;
    
    key2.key_state = KEY_STATE_RELEASE;
}



void bsp_key_check(key_typedef* key)
{
    if((drv_gpio_read(OM_GPIO0,GPIO_MASK(key->key_pin)) >> key->key_pin) == key->key_valid_level)
    {
        if(key->key_state == KEY_STATE_RELEASE)
        {
            key->key_press_count++;
            
            key->key_release_count = 0;
            
            if(key->key_press_count >= key->key_count)
            {
                key->key_press_count = key->key_count;
                
                key->key_state = KEY_STATE_PRESS;
            }
        }
        else
        {
            key->key_release_count = 0;
        }
    }
    else
    {
        if(key->key_state == KEY_STATE_PRESS)
        {
            key->key_release_count++;
            
            key->key_press_count = 0;
            
            if(key->key_release_count >= key->key_count)
            {
                key->key_release_count = key->key_count;
                
                key->key_state = KEY_STATE_RELEASE;
            }
        }
        else
        {
            key->key_press_count = 0;
        } 
    }
}

 

void bsp_key_check_demo(void)
{
    DRV_DELAY_MS(1);
    
    bsp_key_check(&key1);
    
    bsp_key_check(&key2);
    
    if(key1.key_state == KEY_STATE_PRESS)
    {
        led1_on();
    }
    else
    {
        led1_off();
    }
    
    if(key2.key_state == KEY_STATE_PRESS)
    {
        led2_on();
    }
    else
    {
        led2_off();
    }
}


static void key_int_cb(void *om_tim, drv_event_t event, void *int_status, void *gpio_data)
{
    if (event == DRV_EVENT_COMMON_GENERAL) 
    {
		if(((uint32_t)int_status & GPIO_MASK(PAD_KEY1)))
		{
			flag_key1 = 1;
		}
		
		if(((uint32_t)int_status & GPIO_MASK(PAD_KEY2)))
		{
			flag_key2 = 1;
		}
    }
}



void bsp_key_int_init(void)
{
    drv_pin_init(key_cfg_cnt, sizeof(key_cfg_cnt) / sizeof(key_cfg_cnt[0]));
    
    drv_gpio_init(key_int_gpio_config, sizeof(key_int_gpio_config) / sizeof(key_int_gpio_config[0]));
    
    drv_gpio_register_isr_callback(OM_GPIO0,key_int_cb);
}


void bsp_key_int_demo(void)
{
	static uint8_t index1 = 0,index2 = 0;
	
	if(flag_key1 == 1)
	{
		flag_key1 = 0;
		
		if(index1 == 0)
        {
            led1_on();

            index1 = 1;
        }
        else
        {
            led1_off();
            
            index1 = 0;
        }
	}
	
	
	if(flag_key2 == 1)
	{
		flag_key2 = 0;
		
		if(index2 == 0)
        {
            led2_on();

            index2 = 1;
        }
        else
        {
            led2_off();
            
            index2 = 0;
        }
	}
}




