#include "bsp.h"


/// Pin configuration
static const pin_config_t led_cfg_cnt[] = 
{	
    {PAD_LED1, {MUX_LED1}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
	{PAD_LED2, {MUX_LED2}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
};
static const gpio_config_t led_gpio_config[] = 
{
    {OM_GPIO0, PAD_LED1, GPIO_DIR_OUTPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_NONE},
    {OM_GPIO0, PAD_LED2, GPIO_DIR_OUTPUT, GPIO_LEVEL_HIGH, GPIO_TRIG_NONE},
};


void bsp_led_init(void)
{
    drv_pin_init(led_cfg_cnt, sizeof(led_cfg_cnt) / sizeof(led_cfg_cnt[0]));
    
    drv_gpio_init(led_gpio_config, sizeof(led_gpio_config) / sizeof(led_gpio_config[0]));
    
    led1_off();
    led2_off();
}


void led1_on(void)
{
    drv_gpio_write(OM_GPIO0,GPIO_MASK(PAD_LED1),GPIO_MASK(PAD_LED1));
}

void led1_off(void)
{
    drv_gpio_write(OM_GPIO0,GPIO_MASK(PAD_LED1),0);
}

void led2_on(void)
{
    drv_gpio_write(OM_GPIO0,GPIO_MASK(PAD_LED2),GPIO_MASK(PAD_LED2));
}

void led2_off(void)
{
    drv_gpio_write(OM_GPIO0,GPIO_MASK(PAD_LED2),0);
}

void bsp_led_demo(void)
{
    static uint8_t index = 0;
	
	switch(index)
    {
        case 0:
            
            led1_off();
            led2_off();
        
            break;
        
       case 1:
            
            led1_on();
            led2_on();
        
            break;

       case 2:
            
            led1_off();
            led2_off();
        
            break;
        
       case 3:
            
            led1_on();
            led2_on();
        
            break;
            
       case 4:
            
            led1_off();
            led2_off();
        
            break;
        
       case 5:
            
            led1_on();
            led2_off();
        
            break;
       
        case 6:
            
            led1_off();
            led2_on();
        
            break;
        
        case 7:
            
            led1_on();
            led2_off();
        
            break;
       
        case 8:
            
            led1_off();
            led2_on();
        
            break;
        
        case 9:
            
            led1_off();
            led2_off();
        
            break;
    }
    
    DRV_DELAY_MS(500);
    
    index++; 
    
    if(index >= 10)
    {
        index = 0;
    }   
}




