#include "bsp.h"

#define SFLASH_NUM          10

#define SFLASH_ADDR         128 * 1024

#define SFLASH_SECTOR_SIZE  4 * 1024


/// Buffer that stored the data to be written
static uint8_t sflash_write_buf[SFLASH_NUM];
/// Buffer that stored the data to be read
static uint8_t sflash_read_buf[SFLASH_NUM];


void bsp_sflash_init(void)
{
    drv_sf_enable(OM_SF, DRV_SFS_IFLASH);
}


void bsp_sflash_demo(void)
{
    static uint8_t sflash_index = 0;
    
    uint8_t i= 0;
    
    // Erase 4k in 128k
    drv_sf_erase(OM_SF, DRV_SFS_IFLASH, SFLASH_ADDR, SFLASH_SECTOR_SIZE);
    
    // Read 10 bytes in 128k, it should be all 0xFF
    drv_sf_read(OM_SF, DRV_SFS_IFLASH, SFLASH_ADDR, sflash_read_buf, SFLASH_NUM);
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < SFLASH_NUM;i++)
    {
        om_printf("data[%d] = %x \r\n",i,sflash_read_buf[i]);
    } 
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < SFLASH_NUM;i++)
    {
        sflash_write_buf[i] = i + sflash_index;
    } 
    
    sflash_index++;
    
    // Write 10 bytes to 128k
    drv_sf_write(OM_SF, DRV_SFS_IFLASH, SFLASH_ADDR, sflash_write_buf, SFLASH_NUM);
    
    // Read 10 bytes in 128k, it should be same as write_buf
    drv_sf_read(OM_SF, DRV_SFS_IFLASH, SFLASH_ADDR, sflash_read_buf, SFLASH_NUM);
    
    for(i = 0;i < SFLASH_NUM;i++)
    {
        om_printf("data[%d] = %x \r\n",i,sflash_read_buf[i]);
    } 
}



