#include "bsp.h"


/// Pin configuration
static const pin_config_t w25qxx_cfg_cnt[] = 
{
    {PAD_W25QXX_CS,  {MUX_W25QXX_CS},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_W25QXX_CLK, {MUX_W25QXX_CLK}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_W25QXX_DI,  {MUX_W25QXX_DI},  PMU_PIN_MODE_PU, PMU_PIN_DRIVER_CURRENT_NORMAL},
    {PAD_W25QXX_DO,  {MUX_W25QXX_DO},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
};


#define W25QXX_ADDR       0

#define W25QXX_DATA_NUM   10

uint8_t w25qxx_write_data[W25QXX_DATA_NUM] = {0};

uint8_t w25qxx_read_data[W25QXX_DATA_NUM] = {0};



void w25qxx_write_one_byte_command(uint8_t cmd)
{
	uint8_t send_data[1];
	uint8_t rec_data[1];
	
	send_data[0] = cmd;
	
	drv_spi_transfer(W25QXX_SPI, &send_data[0], 1, &rec_data[0], 1,W25QXX_TIME_OUT); 	
}

void w25qxx_write_two_byte_command(uint8_t cmd1,uint8_t cmd2)
{
	uint8_t send_data[2];
	uint8_t rec_data[2];
	
	send_data[0] = cmd1;
	
	send_data[1] = cmd2;
	
	drv_spi_transfer(W25QXX_SPI, &send_data[0], 2, &rec_data[0], 2,W25QXX_TIME_OUT); 	
}


uint8_t w25qxx_read_one_byte_command(uint8_t cmd)
{
	uint8_t send_data[2];
	uint8_t rec_data[2];
	
	send_data[0] = cmd;
	
	send_data[1] = 0xFF;
	
	drv_spi_transfer(W25QXX_SPI, &send_data[0], 2, &rec_data[0], 2,W25QXX_TIME_OUT); 

	return rec_data[1];
}


void w25qxx_write_enable(void)  
{
	w25qxx_write_one_byte_command(W25X_WriteEnable);
}


void w25qxx_write_disable(void)  
{
	w25qxx_write_one_byte_command(W25X_WriteDisable);
}


void w25qxx_powerdown(void)  
{
	w25qxx_write_one_byte_command(W25X_PowerDown);
}


void w25qxx_wakeup(void)  
{
	w25qxx_write_one_byte_command(W25X_ReleasePowerDown);
}


uint8_t w25qxx_read_sr_reg1(void)  
{
	return w25qxx_read_one_byte_command(W25X_ReadStatusReg1);
}


uint8_t w25qxx_read_sr_reg2(void)  
{
	return w25qxx_read_one_byte_command(W25X_ReadStatusReg2);
}


uint8_t w25qxx_read_sr_reg3(void)  
{
	return w25qxx_read_one_byte_command(W25X_ReadStatusReg3);
}


void w25qxx_write_sr_reg1(uint8_t state)  
{
	w25qxx_write_two_byte_command(W25X_WriteStatusReg1,state);
}


void w25qxx_write_sr_reg2(uint8_t state)  
{
	w25qxx_write_two_byte_command(W25X_WriteStatusReg2,state);
}


void w25qxx_write_sr_reg3(uint8_t state)  
{
	w25qxx_write_two_byte_command(W25X_WriteStatusReg3,state);
}


//ȡоƬID
//ֵ:				   
//0XEF13,ʾоƬͺΪW25Q80  
//0XEF14,ʾоƬͺΪW25Q16    
//0XEF15,ʾоƬͺΪW25Q32  
//0XEF16,ʾоƬͺΪW25Q64 
//0XEF17,ʾоƬͺΪW25Q128 	  
//0XEF18,ʾоƬͺΪW25Q256
uint16_t w25qxx_read_id(void)  
{
	uint16_t temp = 0;
	
	uint8_t send_data[6] = {W25X_ManufactDeviceID,0,0,0,0xff,0xff};
	
	uint8_t rec_data[6] = {0};
	
	drv_spi_transfer(W25QXX_SPI, &send_data[0], 6, &rec_data[0], 6,W25QXX_TIME_OUT); 
	
	temp |= rec_data[4]<<8;  
	temp |= rec_data[5];	
			    
	return temp;
}



void w25qxx_wait_busy(void)   
{   
	while((w25qxx_read_sr_reg1() & 0x01) == 0x01);   
}  

//ȡSPI FLASH  
//ַָʼȡָȵ
//pBuffer:ݴ洢
//ReadAddr:ʼȡĵַ(24bit)
//NumByteToRead:Ҫȡֽ(65535)
void w25qxx_read(uint8_t* pBuffer,uint32_t ReadAddr,uint16_t NumByteToRead) 
{
	uint8_t send_data[NumByteToRead + 4];
	
	uint8_t rec_data[NumByteToRead + 4];
	
	send_data[0] = W25X_ReadData;
	
	send_data[1] = (uint8_t)(ReadAddr >> 16);
	
	send_data[2] = (uint8_t)(ReadAddr >> 8);
	
	send_data[3] = (uint8_t)(ReadAddr >> 0);
	
	drv_spi_transfer(W25QXX_SPI,&send_data[0], NumByteToRead + 4,&rec_data[0], NumByteToRead + 4,W25QXX_TIME_OUT);
	
	memcpy(&pBuffer[0], &rec_data[4], NumByteToRead);
}

//SPIһҳ(0~65535)д256ֽڵ
//ַָʼд256ֽڵ
//pBuffer:ݴ洢
//WriteAddr:ʼдĵַ(24bit)
//NumByteToWrite:Ҫдֽ(256),Ӧóҳʣֽ!!!	
void w25qxx_write_page(uint8_t* pBuffer,uint32_t WriteAddr,uint16_t NumByteToWrite)
{
	uint8_t send_data[NumByteToWrite + 4];
	
	uint8_t rec_data[NumByteToWrite + 4];
	
	w25qxx_write_enable();
	
	send_data[0] = W25X_PageProgram;
	
	send_data[1] = (uint8_t)(WriteAddr >> 16);
	
	send_data[2] = (uint8_t)(WriteAddr >> 8);
	
	send_data[3] = (uint8_t)(WriteAddr >> 0);
    
    memcpy(&send_data[4], &pBuffer[0], NumByteToWrite);
	
	drv_spi_transfer(W25QXX_SPI,&send_data[0], NumByteToWrite + 4,&rec_data[0], NumByteToWrite + 4,W25QXX_TIME_OUT);
	
	w25qxx_wait_busy();
}


void w25qxx_erase_chip(void)
{
	uint8_t send_data[1];
	
	uint8_t rec_data[1];
	
	send_data[0] = W25X_ChipErase;
	
	w25qxx_write_enable();
	
	w25qxx_wait_busy();
	
	drv_spi_transfer(W25QXX_SPI,&send_data[0], 1,&rec_data[0], 1,W25QXX_TIME_OUT);
	
	w25qxx_wait_busy();
}


void w25qxx_erase_sector(uint16_t sector_index)
{
	uint8_t send_data[4];
	
	uint8_t rec_data[4];
	
	uint32_t sector_addr = 0;
	
	sector_addr = sector_index << 12;
	
	w25qxx_write_enable();
	
	w25qxx_wait_busy();
	
	send_data[0] = W25X_SectorErase;
	
	send_data[1] = (uint8_t)(sector_addr >> 16);
	
	send_data[2] = (uint8_t)(sector_addr >> 8);
	
	send_data[3] = (uint8_t)(sector_addr >> 0);
	
	drv_spi_transfer(W25QXX_SPI,&send_data[0], 4,&rec_data[0], 4,W25QXX_TIME_OUT);
	
	w25qxx_wait_busy();
}



void bsp_spi_w25qxx_init(void)
{
	spi_config_t spi_cfg = 
	{
        .freq       = 16*1000*1000,
		.role       = SPI_ROLE_MASTER,
		.mode       = SPI_MODE_0,
		.wire       = SPI_WIRE_4,
		.first_bit  = SPI_MSB_FIRST,
		.cs_valid   = SPI_CS_LOW,
    };

	drv_pin_init(w25qxx_cfg_cnt, sizeof(w25qxx_cfg_cnt) / sizeof(w25qxx_cfg_cnt[0]));
	
	drv_spi_init(W25QXX_SPI, &spi_cfg);
	
	register_set(&OM_SPI1->DELAY_SAMPLE, MASK_1REG(SPI_DELAY_SAMPLE_CYCLE_NUM, (uint32_t)1 /* argu = 1,2,3 */));	
}


void bsp_spi_w25qxx_demo(void)
{
	uint8_t i= 0;
    
    static uint8_t w25qxx_index = 0;
    
    uint16_t w25qxx_type = 0;

	w25qxx_type = w25qxx_read_id();
	
    om_printf("\r\n\r\n");
    
	om_printf("flash_id = %x \r\n",w25qxx_type);
	
	w25qxx_erase_sector(W25QXX_ADDR>>12);
	
    w25qxx_write_page(w25qxx_write_data,W25QXX_ADDR,W25QXX_DATA_NUM);
    
    for(i = 0;i < W25QXX_DATA_NUM;i++)
    {
        w25qxx_write_data[i] = i + w25qxx_index;
    }
    
    w25qxx_index++;
    
    w25qxx_read(w25qxx_read_data,W25QXX_ADDR,W25QXX_DATA_NUM);
    
    om_printf("\r\n\r\n");
    
    for(i = 0;i < W25QXX_DATA_NUM;i++)
    {
        om_printf("data[%d] = %x \r\n",i,w25qxx_read_data[i]);
    }
    
    om_printf("\r\n\r\n");
}



