#include "bsp.h"


uint32_t pwm_complementary = 0;

uint32_t timer_1ms = 0;

uint8_t flag_timer_32bit = 0;

uint32_t pwm_compare = 0;

static const pin_config_t pwm_cfg_cnt[] = 
{
    {PAD_TIM1_PWM_CH1, {MUX_TIM1_PWM_CH1}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
};



tim_gp_config_t tim_cfg = 
{
    .period_us = 1 * 1000,
};


tim_pwm_input_config_t pwm_input_cfg = 
{
	.cnt_freq = 1000000
};


tim_pwm_output_config_t pwm_config = 
{
    .cnt_freq = 1000000,            // 1Mhz
    
    .chan = 
    {
        {0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
        {0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
        {0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
        {0, {TIM_PWM_POL_ACTIVE_HIGH, 0}}
    },
    
    .dma_cfg = 
    {
        0, TIM_CHAN_ALL, NULL
    },
};


tim_capture_config_t capture_config = 
{
	.cnt_freq = 1000000,
	.chan = 
	{
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE}
	},
    .dma_cfg = 
	{
		.en       = 0,
		.tim_chan = TIM_CHAN_ALL,
		.chain    = NULL
	},
};


tim_pwm_complementary_output_config_t pwm_complementary_config = 
{
	.cnt_freq = 1000000,            // 1Mhz
	
	.chan = 
	{
		{0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
		{0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
		{0, {TIM_PWM_POL_ACTIVE_HIGH, 0}},
		{0, {TIM_PWM_POL_ACTIVE_HIGH, 0}}
	},
	
	.dma_cfg = 
	{
		0, TIM_CHAN_ALL, NULL
	},
};



typedef struct 
{
    uint8_t     cap_index;
    uint32_t    cap_overflow;
    uint32_t    cap_buf[CAP_SAMPLE_NUM];
} cap_env_t;


typedef struct {
    dma_chain_trans_t chain[3];
    uint16_t buf0[CAP_SAMPLE_NUM];
    uint16_t buf1[CAP_SAMPLE_NUM];
    uint16_t buf2[CAP_SAMPLE_NUM];
} cap_dma_env_t;



typedef struct 
{
    uint32_t cap_overflow;
    uint32_t cap_cc1_index;
    uint32_t cap_cc2_index;
    uint32_t cap_cc1_buf[CAP_SAMPLE_NUM];
    uint32_t cap_cc2_buf[CAP_SAMPLE_NUM];
} pwm_input_env_t;


static cap_env_t        cap_env;

static pwm_input_env_t  pwm_input_env;

static cap_dma_env_t    cap_dma_env;


tim_capture_config_t capture_dma_config = 
{
	.cnt_freq = 1000000,
	.chan = 
	{
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE},
		{0, TIM_CAPTURE_POLARITY_RISING_EDGE}
	},
	
	.dma_cfg = 
	{
		.en = 1,
		.tim_chan = TIM_CHAN_1,
		.chain = &cap_dma_env.chain[0]
	}
};


static void timer_count_cb(void *om_tim, drv_event_t event, void *buff, void *num)
{
    if (event == DRV_EVENT_TIMER_UPDATE) 
    {
		timer_1ms++;
    }
}


void bsp_tim_count_init(void)
{
    drv_tim_init(OM_TIM0);
    
    drv_tim_register_event_callback(OM_TIM0, timer_count_cb);

    drv_tim_gp_start(OM_TIM0, &tim_cfg);
}


void bsp_tim_count_demo(void)
{
    static uint8_t index = 0;
    
    if(timer_1ms >= 1000)
    {
        timer_1ms = 0;
        
        if(index == 0)
        {
            led1_off();
            led2_off();
            
            index = 1;
        }
        else
        {
            led1_on();
            led2_on();
            
            index = 0;
        }
    }
}



static void tim_pwm_input_callback(void *om_tim, drv_event_t event, void *buff, void *num)
{
    if (event & DRV_EVENT_TIMER_TRIGGER) 
	{
        pwm_input_env.cap_overflow = 0;
    }

    if (event & DRV_EVENT_TIMER_UPDATE) 
	{
        pwm_input_env.cap_overflow++;
    }

    if (pwm_input_env.cap_cc1_index < CAP_SAMPLE_NUM && (event & DRV_EVENT_TIMER_CC1)) 
	{
        pwm_input_env.cap_cc1_buf[pwm_input_env.cap_cc1_index++] = (uint32_t)buff + pwm_input_env.cap_overflow * 0xFFFF;
    }

    if (pwm_input_env.cap_cc2_index < CAP_SAMPLE_NUM && (event & DRV_EVENT_TIMER_CC2)) 
	{
        pwm_input_env.cap_cc2_buf[pwm_input_env.cap_cc2_index++] = (uint32_t)buff + pwm_input_env.cap_overflow * 0xFFFF;
    }
}



void bsp_tim_pwm_in_init(void)
{
    pin_config_t pin_config[] = 
	{
        {PAD_TIM0_CAP_CH1, {MUX_TIM0_CAP_CH1}, PMU_PIN_MODE_FLOAT, PMU_PIN_DRIVER_CURRENT_NORMAL},
    };
	
	
    drv_pin_init(pin_config, sizeof(pin_config) / sizeof(pin_config[0]));

    drv_tim_init(OM_TIM0);
	
    drv_tim_register_event_callback(OM_TIM0, tim_pwm_input_callback);
	
    drv_tim_pwm_input_start(OM_TIM0, &pwm_input_cfg);
}



void bsp_tim_pwm_in_demo(void)
{
	uint8_t i = 0;
	
	if(pwm_input_env.cap_cc1_index >= 20 && pwm_input_env.cap_cc2_index >= 20)
	{
		drv_tim_pwm_input_stop(OM_TIM0);
		
		for(i = 0;i < pwm_input_env.cap_cc1_index;i++)
		{
			om_printf("cc1[%d] is %d\r\n",i,pwm_input_env.cap_cc1_buf[i]);
		}
		
		for(i = 0;i < pwm_input_env.cap_cc2_index;i++)
		{
			om_printf("cc2[%d] is %d\r\n",i,pwm_input_env.cap_cc2_buf[i]);
		}
		
		pwm_input_env.cap_cc1_index = 0;
		
		pwm_input_env.cap_cc2_index = 0;
		
		drv_tim_pwm_input_start(OM_TIM0, &pwm_input_cfg);
	}
}


void bsp_tim_pwm_out_init(void)
{
	drv_pin_init(pwm_cfg_cnt, sizeof(pwm_cfg_cnt) / sizeof(pwm_cfg_cnt[0]));
	
    pwm_config.period_cnt                   = PWM_CH1_PERIOD;
    pwm_config.chan[TIM_CHAN_1].en          = 1;
    pwm_config.chan[TIM_CHAN_1].cfg.oc_val  = 300;
    pwm_config.chan[TIM_CHAN_1].cfg.pol     = TIM_PWM_POL_ACTIVE_HIGH;

    drv_tim_init(OM_TIM1);
    drv_tim_pwm_output_start(OM_TIM1, &pwm_config);	
}


void bsp_tim_pwm_out_demo(void)
{
    pwm_compare++;
    
    if(pwm_compare >= PWM_CH1_PERIOD)
    {
        pwm_compare = 0;
    }
    
    drv_tim_pwm_change_oc_val(OM_TIM1,TIM_CHAN_1,pwm_compare);
    
    DRV_DELAY_MS(20);
}


static void tim_capture_callback(void *om_tim, drv_event_t event, void *buff, void *num)
{
    if (event & DRV_EVENT_TIMER_UPDATE) 
	{
        cap_env.cap_overflow++;
    }

    if (cap_env.cap_index < CAP_SAMPLE_NUM && event & DRV_EVENT_TIMER_CC1) 
	{
        cap_env.cap_buf[cap_env.cap_index++] = (uint32_t)buff + cap_env.cap_overflow * 0xFFFF;
    }
}


void bsp_tim_capture_init(void)
{
    pin_config_t pin_config[] = 
	{
        {PAD_TIM0_CAP_CH1, {MUX_TIM0_CAP_CH1}, PMU_PIN_MODE_FLOAT, PMU_PIN_DRIVER_CURRENT_NORMAL},
    };
	
	capture_config.chan[TIM_CHAN_1].en = 1;
	
    drv_pin_init(pin_config, sizeof(pin_config) / sizeof(pin_config[0]));

    drv_tim_init(OM_TIM0);
	
    drv_tim_register_event_callback(OM_TIM0, tim_capture_callback);
	
    drv_tim_capture_start(OM_TIM0, &capture_config);
}


void bsp_tim_capture_demo(void)
{
	uint8_t i = 0;
	
	if(cap_env.cap_index >= 20)
	{
		drv_tim_capture_stop(OM_TIM0,TIM_CHAN_1);
		
		for(i = 0;i < cap_env.cap_index;i++)
		{
			om_printf("cap[%d] is %d\r\n",i,cap_env.cap_buf[i]);
		}
			
		cap_env.cap_index = 0;
	
		drv_tim_capture_start(OM_TIM0, &capture_config);
	}
}



void bsp_tim_pwm_complementary_init(void)
{
	pin_config_t pin_cfg[] = 
	{
        {PAD_TIM1_PWM_CH1,  {MUX_TIM1_PWM_CH1},  PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
		{PAD_TIM1_PWM_CH1N, {MUX_TIM1_PWM_CH1N}, PMU_PIN_MODE_PP, PMU_PIN_DRIVER_CURRENT_NORMAL},
    };
	
	drv_pin_init(pin_cfg, sizeof(pin_cfg) / sizeof(pin_cfg[0]));
	
	pwm_complementary_config.period_cnt                   = 1000;
    pwm_complementary_config.chan[TIM_CHAN_1].en          = 1;
    pwm_complementary_config.chan[TIM_CHAN_1].cfg.oc_val  = 300;
    pwm_complementary_config.chan[TIM_CHAN_1].cfg.pol     = TIM_PWM_POL_ACTIVE_HIGH;
	pwm_complementary_config.chan[TIM_CHAN_1].cfg.complementary_output_enable = true;
	pwm_complementary_config.dead_time = 10;
	
	drv_tim_init(OM_TIM1);
	
    drv_tim_pwm_complementary_output_start(OM_TIM1, &pwm_complementary_config);	
}



void bsp_tim_pwm_complementary_demo(void)
{
    pwm_complementary++;
    
    if(pwm_complementary >= PWM_CH1_PERIOD)
    {
        pwm_complementary = 20;
    }
    
    drv_tim_pwm_change_oc_val(OM_TIM1,TIM_CHAN_1,pwm_complementary);
    
    DRV_DELAY_MS(20);
}


void tim_32bits_handler_cascade(void *om_tim, drv_event_t drv_event, void *buff, void *num)
{
	OM_TIM_Type *om_timer = (OM_TIM_Type *)om_tim;
	
	OM_TIM_Type *om_timer_slave = TIMER_32BIT_SLAVE;
	
    if (drv_event == DRV_EVENT_TIMER_CASCADE_UPDATE) 
	{
		flag_timer_32bit = 1;
		
		om_timer_slave->SR = 0;	        // Must clean slave_tim uif
    }
}


void bsp_tim_count_32bit_init(void)
{
	tim_32bits_config_t tim_cas_config = 
	{
		.slave_tim = TIMER_32BIT_SLAVE,
		.run_mode = TIMER_32BITS,
		.counter = 1,
		.time = 5000000,
		.delay_period = 0,
		.callback_cas_uif = (drv_isr_callback_t)tim_32bits_handler_cascade,
	};
	
	drv_tim_init(TIMER_32BIT_MASTER);
	
	drv_tim_init(TIMER_32BIT_SLAVE);
	
	drv_tim_register_event_callback(TIMER_32BIT_MASTER, tim_32bits_handler_cascade);
	// counter 32bit start
	drv_tim_gp_32bit_start(TIMER_32BIT_MASTER,TIMER_32BIT_SLAVE, &tim_cas_config);	
}


void bsp_tim_count_32bit_demo(void)
{
	static uint8_t index = 0;
    
	if(flag_timer_32bit == 1)
	{
		flag_timer_32bit = 0;
		
		if(index == 0)
        {
            led1_off();
            led2_off();
            
            index = 1;
        }
        else
        {
            led1_on();
            led2_on();
            
            index = 0;
        }
	}
}















void bsp_tim_capture_dma_init(void)
{
    pin_config_t pin_config[] = 
	{
        {PAD_TIM0_CAP_CH1, {MUX_TIM0_CAP_CH1}, PMU_PIN_MODE_FLOAT, PMU_PIN_DRIVER_CURRENT_NORMAL},
    };
	
	cap_dma_env.chain[0].dst_addr   = (uint32_t)cap_dma_env.buf0;
    cap_dma_env.chain[0].size_byte  = CAP_SAMPLE_NUM * sizeof(uint16_t);
    cap_dma_env.chain[0].ll_ptr     = &cap_dma_env.chain[1];

    cap_dma_env.chain[1].dst_addr   = (uint32_t)cap_dma_env.buf1;
    cap_dma_env.chain[1].size_byte  = CAP_SAMPLE_NUM * sizeof(uint16_t);
    cap_dma_env.chain[1].ll_ptr     = &cap_dma_env.chain[2];

    cap_dma_env.chain[2].dst_addr   = (uint32_t)cap_dma_env.buf2;
    cap_dma_env.chain[2].size_byte  = CAP_SAMPLE_NUM * sizeof(uint16_t);
    cap_dma_env.chain[2].ll_ptr     = &cap_dma_env.chain[0];
	
	
	capture_dma_config.chan[TIM_CHAN_1].en = 1;
	
	
	drv_tim_init(OM_TIM0);
	
    drv_tim_dma_channel_allocate(OM_TIM0);
	
    drv_tim_capture_start(OM_TIM0, &capture_dma_config);
}


void bsp_tim_capture_dma_demo(void)
{
	

}












