/**
 * @file om_log.c
 * @brief
 * @date Thu 23 Feb 2023 09:10:58 AM CST
 * @author liqiang
 *
 * @addtogroup
 * @ingroup
 * @details
 *
 * @{
 */

/*********************************************************************
 * INCLUDES
 */
#include "features.h"
#include "om_log.h"
#include <stdint.h>
#include <stdarg.h>

#if (CONFIG_LOG)

#if (CONFIG_SEGGER)
#include "SEGGER_SYSVIEW.h"
#endif

#if (CONFIG_LOG_TO_SHELL)
#include "shell.h"
#endif

/*********************************************************************
 * MACROS
 */


/*********************************************************************
 * TYPEDEFS
 */


/*********************************************************************
 * CONSTANTS
 */


/*********************************************************************
 * LOCAL VARIABLES
 */
static om_log_level_t om_log_level = (om_log_level_t)CONFIG_LOG_LEVEL;

/*********************************************************************
 * GLOBAL VARIABLES
 */


/*********************************************************************
 * LOCAL FUNCTIONS
 */


/*********************************************************************
 * PUBLIC FUNCTIONS
 */

/**
 * @brief  om log
 *
 * @param[in] level  level
 * @param[in] fmt  fmt
 **/
void om_log(om_log_level_t level, const char *fmt, ...)
{
    /*lint -save -e530*/
    va_list ap;

    va_start(ap, fmt);
    if (om_log_level >= level) {
#if (CONFIG_LOG_TO_SEGGER_SYSVIEW)
        uint32_t om2sysview_level_tbl[] = [0, SEGGER_SYSVIEW_ERROR, SEGGER_SYSVIEW_WARNING, SEGGER_SYSVIEW_LOG];
        SEGGER_SYSVIEW_VPrintfTarget(fmt, om2sysview_level_tbl[level], &ap);
#elif (CONFIG_LOG_TO_SHELL)
        om_vprintf(fmt, ap);
#endif
    }
    va_end(ap);
    /*lint -restore */
}

/**
 * @brief  om log level set
 *
 * @param[in] level  level
 **/
void om_log_level_set(om_log_level_t level)
{
    om_log_level = level;
}

#else
void om_log(om_log_level_t level, const char *fmt, ...) {}
void om_log_level_set(om_log_level_t level) {}
#endif

/** @} */

