#ifndef __LCM_DMA_SPI_H__
#define __LCM_DMA_SPI_H__

#include "board.h"

#define FLUSH_LCM_EVT_START			(EVT_TYPE_USR_FIRST + 0)
#define DECOMPRES_BMP_EVT				(EVT_TYPE_USR_FIRST + 1)

#define SPI_SPEED								(32 * 1000 * 1000) // SPI速率，MCU主频设置64M的情况下，SPI才能跑32M

#define LCD_COLOR_WHITE					0xFF // 纯白色像素---无论在哪个像素下都是
#define LCD_COLOR_BLACK					0x00 // 纯黑色像素---无论在哪个像素下都是

#define LCD_FULLSCREEN_COLUMN		240 // LCD的像素列数
#define LCD_FULLSCREEN_ROW			240 // LCD的像素行数

#define RGB565_ONEPIXEL_BYTES		2 // 表示一个RGB565像素点的数据字节数

#define RGB565_FULLSCREEN_BYTES	(LCD_FULLSCREEN_COLUMN * LCD_FULLSCREEN_ROW * RGB565_ONEPIXEL_BYTES) // 一整屏RGB565像素点的字节数

#define RGB565_LINE_BYTES				(LCD_FULLSCREEN_COLUMN * RGB565_ONEPIXEL_BYTES * 10) // 一行RGB565像素点的字节数

#define LINE_BYTES							RGB565_LINE_BYTES
#define FULLSCREEN_BYTES				RGB565_FULLSCREEN_BYTES

#define _WHITE									0xffff
#define _BLACK									0x0000
#define _BLUE										0x001f
#define _GREEN									0x07e0
#define _GREEN1									0x1b03
#define _RED										0xf800
#define _YELLOW									0xffe0
#define _YELLOW1								0xffeb
#define _ORANGE									0xf4a0
#define _BROWN									0xbc40
#define _BLUE1									0x749f
#define _BLUE2									0x047d
#define _PINK1									0xe00f
#define _GREEN2									0x3ff7
#define _GREEN3									0x3fa7
#define _PURPLR									0xe45f
#define _RGB565_RED							0xF800
#define _RGB565_GREEN						0x07E0
#define _RGB565_GREEN1					0x1B03
#define _RGB565_BLUE						0x001F
#define _RGB565_BLUE1						0x749F
#define _RGB565_WHITE						0xFFFF
#define _RGB565_BLACK						0x0000
#define _RGB565_CYAN						0x07FF
#define _RGB565_CYAN1						0x07FA
#define _RGB565_YELLOW					0xFFE0
#define _RGB565_YELLOW1					0xFFEB
#define _RGB565_PINK						0xF81F
#define _PRESSING								0x07EF
#define _RGB565(R, G, B)				((R & 0xF8) << 8) | ((G & 0xFC) << 3) | (B >> 3)
#define _RGB565_HIGHLIGHT				RGB565(204, 204, 204)
#define _RGB565_LIGHT						RGB565(77, 77, 77)
#define _RGB565_EXERCISE				RGB565(0x3a, 0x98, 0x1c)
#define _RGB565_PROGRESS				RGB565(204, 204, 204)

#define SPI_CMD_WREN        		0x06u /* Write enable */
#define SPI_CMD_WRDI        		0x04u /* Write disable */
#define SPI_CMD_RDSR        		0x05u /* Read status register */
#define SPI_CMD_RDSR2       		0x35u /* Read status register (high byte) */
#define SPI_CMD_WRSR        		0x01u /* Write status register */
#define SPI_CMD_READ        		0x03u /* Read data bytes (low frequency) */
#define SPI_CMD_FAST_READ   		0x0Bu /* Read data bytes (high frequency) */
#define SPI_CMD_DUAL_READ   		0x3Bu /* Dual output fast read: HS6620 doesn't support 0xBB */
#define SPI_CMD_QUAD_READ   		0x6Bu /* Quad output fast read: PN25F04C doesn't support 0x6B, but HS6620 doesn't support 0xEB */
#define SPI_CMD_PP          		0x02u /* Page program (up to page in 256 bytes) */
#define SPI_CMD_RDID        		0x9fu /* Read JEDEC ID */
#define SPI_CMD_RDUID       		0x4Bu /* Read UID */
#define SPI_CMD_SE          		0x20u /* Sector erase (usually 4KiB) */
#define SPI_CMD_BE_32K      		0x52u /* Erase 32KiB block */
#define SPI_CMD_BE_64K      		0xD8u /* Erase 64KiB block */
#define SPI_CMD_CE          		0x60u /* Erase whole flash chip, or 0xC7 */
#define SPI_CMD_ENDP        		0xB9u /* Enter Deep Power-Down */
#define SPI_CMD_EXDP        		0xABu /* Exit Deep Power-Down */
#define SPI_CMD_RDSEC       		0x48u /* Read Security Registers */
#define SPI_CMD_ERSEC       		0x44u /* Erase Security Registers */
#define SPI_CMD_PPSEC       		0x42u /* Program Security Registers */
#define SPI_CMD_SUSPEND     		0x75u /* Program/Erase Suspend */
#define SPI_CMD_RESUME      		0x7Au /* Program/Erase Resume */
#define SPI_CMD_EQPI        		0x38u /* Enable Quad Peripheral Interface: HS6620 doesn't support */

#define SR_WIP              		0x0001 /* Write in progress */
#define SR_WEL              		0x0002 /* Write enable latch */
#define SR_BP0              		0x0004 /* Block protect 0 */
#define SR_BP1              		0x0008 /* Block protect 1 */
#define SR_BP2              		0x0010 /* Block protect 2 */
#define SR_BP3              		0x0020 /* Block protect 3 */
#define SR_BP4              		0x0040 /* Block protect 4 */
#define SR_SRP0             		0x0080 /* SR write protect 0 */
#define SR_SRP1             		0x0100 /* SR write protect 1 */
#define SR_QE               		0x0200 /* Quad enable */
#define SR_SUS2             		0x0400 /* Suspend status 2, bad compatibility */
#define SR_LB1              		0x0800 /* Lock OTP 1, bad compatibility */
#define SR_LB2              		0x1000 /* Lock OTP 2, bad compatibility */
#define SR_LB3              		0x2000 /* Lock OTP 3, bad compatibility */
#define SR_CMP              		0x4000 /* Block protect: conjunction the BP4-BP0 */
#define SR_SUS1             		0x8000 /* Suspend status 1 */

#define DISPLAY_BUFFER_LEN  (240 * 24) // 指定缓冲的长度

typedef struct
{
    uint8_t mid;
    uint8_t cid;
    bool    present;
}flash_info_t;

typedef struct
{
	uint16_t bmp_total_num; // how many bmp to flush
	uint16_t bmp_num_add; // flush one bmp add 1

	uint8_t buf_num;

	uint32_t bmp_Flash_addr;
	uint32_t bmp_pix_addr;

	uint32_t bmp_length;
	int32_t left_len;
	int32_t bulk_read_len;
}flush_bmp_info_t;

extern flash_info_t m_flash_info;
extern flush_bmp_info_t flush_bmp_info;

extern volatile uint8_t spi0_int_transfer_is_done_test;
extern volatile uint8_t spi1_int_transfer_is_done_test;

extern char FrameBuffer[DISPLAY_BUFFER_LEN]; // 指定显示缓冲，可以和16位缓冲一样大小。可以是字节指针
extern char FrameBuffer_B[DISPLAY_BUFFER_LEN]; // 指定显示缓冲，可以和16位缓冲一样大小。可以是字节指针

void lcd_spi_turn_on(char on_off);

//void lcm_back_light(back_light_state_t State);

void spi_normal_lcd_write_reg(OM_SPI_Type *SPIx, char CSx, uint8_t reg, uint8_t *txbuf, int nByte);

void spi_normal_lcd_write_mem_ex(OM_SPI_Type *SPIx, char CSx, uint8_t *txbuf, int nByte);

void DoubleBuffer_lcd_write(OM_SPI_Type *SPIx, char CSx, uint8_t *txbuf, int nByte);

void SPI_3wire_8bit_serial_data_buf(char *da, uint32_t len);

void lcd_pixer_trans(char start_stop);

void lcm_screen_address_set(uint32_t x1, uint32_t y1, uint32_t x2, uint32_t y2);

void clear_Screen(uint16_t color);

void lcd_fill_area(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, uint16_t color);

void lcm_sleep_mode_control(uint8_t lcd_sleep);

void drv_spi_flash_init(void);

void drv_spi_flash_uninit(void);

void lcm_init(void);

void gif_show(void);

void decompres_bmp_evt_cb(void);

int8_t sf_read(uint32_t *flash_addr, uint32_t *ram_addr, uint32_t len, uint8_t wait);

#endif