#include "headfiles.h"

#include "lcm_config.h"

#if  ST7789HSD

/******************************************************************************************
 Function:		lcd_st7789_init
 Description: 	Initialize the LCD of st7789 
 Input:			void
 Output:		none
 Return:		void

 Athor 			Date			Note
 	mengzy		2019-05-08		draft
 	tangtl		2020-11-07		Add micro control for adapting different RGB or Line mode
 								Add notes of different commands 
*******************************************************************************************/
void lcd_st7789_init(void)
{
    uint8_t reg;
    uint8_t buf[16];
    uint8_t *const start = buf;
    uint8_t *p = buf;

    gpio_write(BITMASK(LCD_EN_PIN), GPIO_HIGH);
    gpio_write(BITMASK(LCD_RES_PIN), GPIO_HIGH);
    co_delay_ms(5);
    gpio_write(BITMASK(LCD_RES_PIN), GPIO_LOW);
    co_delay_ms(5);
    gpio_write(BITMASK(LCD_RES_PIN), GPIO_HIGH);
    co_delay_ms(5);

    //Sleep out command in sf->COMMAND_DATA0_REG[0]
    reg = 0x11;
    lcd_write_reg(HS_SF1, 0, reg, NULL, 0);

    co_delay_ms(5);

    p = start;
    reg = 0xB1; //RGB Control
    *p++ = 0x05;
    *p++ = 0x3c;
    *p++ = 0x3c;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xB2; //Porch Control
    //*p++ = 0x05;
    //*p++ = 0x3c;
    //*p++ = 0x3c;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xB3; //Frame rate control
    *p++ = 0x05;
    *p++ = 0x3c;
    *p++ = 0x3c;
    *p++ = 0x05;
    *p++ = 0x3c;
    *p++ = 0x3c;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xB4;
    *p++ = 0x03;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC0; //LCM control
    *p++ = 0x28;
    *p++ = 0x08;
    *p++ = 0x04;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC1; //ID Setting
    *p++ = 0xC0;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC2; //VDV and VRH
    *p++ = 0x0D;
    *p++ = 0x00;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC3; //VRH Setting
    *p++ = 0x8D;
    *p++ = 0x2A;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC4; //VDV Set
    *p++ = 0x8D;
    *p++ = 0xEE;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xC5; //VCMOS Offset Set
    *p++ = 0x1A;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0x36; //Memory data access
    *p++ = 0x12;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xE0; //Positive Voltage Gamma
    *p++ = 0x04;
    *p++ = 0x22;
    *p++ = 0x07;
    *p++ = 0x0A;
    *p++ = 0x2E;
    *p++ = 0x30;
    *p++ = 0x25;
    *p++ = 0x2A;
    *p++ = 0x28;
    *p++ = 0x26;
    *p++ = 0x2E;
    *p++ = 0x3A;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x03;
    *p++ = 0x13;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    p = start;
    reg = 0xE1; //Negative Voltage Gamma
    *p++ = 0x04;
    *p++ = 0x16;
    *p++ = 0x06;
    *p++ = 0x0D;
    *p++ = 0x2D;
    *p++ = 0x26;
    *p++ = 0x23;
    *p++ = 0x27;
    *p++ = 0x27;
    *p++ = 0x25;
    *p++ = 0x2D;
    *p++ = 0x3B;
    *p++ = 0x00;
    *p++ = 0x01;
    *p++ = 0x04;
    *p++ = 0x13;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

// #ifndef Data_3Wire_1Lane
#if (nWire == 3) && (nLane == 2)
    //LCD 2 lane
    p = start;
    reg = 0xE7; //SPI2 Enable command in sf->COMMAND_DATA0_REG[0]
    *p++ = 0x10;
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);
#endif

    p = start;
    reg = 0x3A; //Interface pixel format command: 0x55:RGB565  0x66:RGB666
#ifdef RGB565_TEST
    *p++ = 0x55;
#else
    *p++ = 0x66;
#endif
    lcd_write_reg(HS_SF1, 0, reg, start, p - start);

    //Display on command in sf->COMMAND_DATA0_REG[0]
    reg = 0x29;
    lcd_write_reg(HS_SF1, 0, reg, NULL, 0);
}

#endif
