
#include "rf.H"
#include "port_rf.H"
#include "user.H"

extern word point;
byte rf_data_buf[10];
byte tx_id[2];
byte rf_buf,rf_write_data_cnt;
byte rf_reg,rf_data;
byte DelayCnt;
byte  rf_data1,rf_data2;
byte rf_addr;
byte rf_channel;
byte no_rf_delay;

void rf_table(void)
{
	_pcadd
	{
//	ret  0x80; 
	ret  0x2a; ret  0x20; ret  0x01; 
	ret  0x01; ret  0x20; ret  0x7e; //bit13 0 crcر   1 crc
	ret  0x0a; ret  0x20; ret  0x53; 
	ret  0x02; ret  0x40; ret  0x60; 
	ret  0x03; ret  0x0a; ret  0x00; 
	ret  0x05; ret  0x7f; ret  0xa6; 
	ret  0x0f; ret  0x66; ret  0x1d;
	ret  0x0d; ret  0x60; ret  0x03; 

//	ret  0x0b; ret  0x8f; ret  0x7f; 
	ret  0x0b; ret  0x8f; ret  0x7f; //bit11-8  ط

	ret  0x1a; ret  0x00; ret  0xf7; 

	ret  0x1f; ret  0x22; ret  0x11; //ַ
	ret  0x20; ret  0x08; ret  0x53; 
	ret  0x21; ret  0x1d; ret  0xbc; 
	ret  0x22; ret  0x44; ret  0x33;  //ַ
	ret  0xff;
	ret  0xff;
	}
}
/*******************************************************************************
* : Delayus
* : ӳ
* β:       
* : 
* ˵: 
*******************************************************************************/
void Delay100US(void)
{
	byte cnt;
	do
	{
		cnt = 60;
		do
		{
//		wdreset;
		}while(--cnt$0);
	}while(--DelayCnt$0);
}
//===============================================
//rf_io_init
//===============================================
void rf_io_init(void)
{
	spi_sck_c=1;
	spi_csn_c=1;
	spi_data_c=1;
	spi_sck=0;
	spi_csn=1;
	rf_reset_c=1;
	rf_reset=1;


}
//===============================================
//rf address
//===============================================
void rf_tx_id(void)
{
/*	call    _SYS(ADR.ROLL);     //  ȡ Roll:0
	tx_id[0] =   A;
	call    _SYS(ADR.ROLL) +1;  //  ȡ Roll:1
	tx_id[1] =   A;
*/

}
//===============================================
//===============================================
void spi_Writeabyte(void)
{
   byte k=8;
   spi_data_c=1;//

 //  .delay 10
   while(k)
   {     
	    spi_sck=0;               // _|~
   	    .delay 10
		spi_sck=1;   
	   if(rf_buf.7)
	     spi_data=1;
 	   else 
	     spi_data=0;
	   .delay 10
	   spi_sck=0;               // ~|_
 	   rf_buf<<=1;  	   
	   k--;
   }
   spi_sck=0;
} 
//===============================================
//===============================================
void  spi_Readabyte(void)
{
  byte k=8;
  spi_data_c=0;
  spi_data_h=1;
   .delay 10

  while(k)
  {
  	 rf_buf<<=1;
     spi_sck=0;
   .delay 10
     spi_sck=1;
   .delay 10
     if(spi_data)
	    rf_buf.0=1; //   rf_buf |=0x01;
     else
	    rf_buf.0=0; // rf_buf &=0xfe;
	 k--;
  }
     spi_sck=0;
}

//==============================================
//write rf_buf
//==============================================
void write_rf_data_buf(void)
{
     byte temp01_buf;
	spi_csn=0;
	rf_buf=rf_addr;
	spi_Writeabyte();

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	     rf_buf=*point;  
         spi_Writeabyte();
	     point++;
	     temp01_buf++;
	 }
	spi_csn=1;
}
//==============================================
//write rf_buf
//==============================================
void read_rf_data_buf(void)
{
     byte temp01_buf;
	spi_csn=0;
	rf_buf=rf_addr;
	spi_Writeabyte();

	 point=rf_data_buf;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	     rf_buf=*point;  
         spi_Readabyte();
	     point++;
	     temp01_buf++;
	 }
	spi_csn=1;
}
//===============================================
//Reg_read16
//===============================================
void Reg_read16(void)
{
	spi_csn=0;
	rf_buf=rf_addr|0x80;
	spi_Writeabyte();
	rf_buf=rf_data1;

	spi_Readabyte();
	rf_data1=rf_buf;
	spi_Readabyte();
	rf_data2=rf_buf;
	spi_csn=1;
}
//===============================================
//reg_write16
//===============================================
void reg_write16(void)
{
	spi_csn=0;
	rf_buf=rf_addr;
	spi_Writeabyte();
	rf_buf=rf_data1;
	spi_Writeabyte();
	rf_buf=rf_data2;
	spi_Writeabyte();
	spi_csn=1;
	.delay 100
}
//===============================================
//set_rf_channel
//===============================================
void set_rf_channel(void)
{
	rf_addr=RXTX_CTRL;
	Reg_read16();
	rf_data1 &= 0x00;
	rf_data2 |= rf_channel;
	reg_write16();
}
//===============================================
//flush fifo
//===============================================
void flush_tx_fifo(void)
{
	rf_addr=TXFIFO_PTR;
	rf_data1 = 0x80;
	rf_data2 = 0x80;
	reg_write16();
}
//===============================================
//flush fifo
//===============================================
void flush_rx_fifo(void)
{
	rf_addr=RXFIFO_PTR;
	rf_data1 = 0x80;
	rf_data2 = 0x80;
	reg_write16();
}
//===============================================
//rf_RecivePack
//===============================================
void enable_recive(void)   //ʹܽ  Ƶ34
{
		flush_rx_fifo();
		rf_addr=00;
		rf_data1 = 0x40;
		rf_data2 = rf_channel;
		reg_write16();
}
//-----------------------------------------------------------------------------
// RF ʼ
//----------------------------------------------------------------------------- 
//byte rf_delay_2ms;
extern byte rf_reset_cnt;
void rf_Init(void)
{
	rf_io_init();
	byte temp00;

	spi_csn= 1; 
//	spi_data= 1; 
//	spi_sck = 1;
	rf_reset_cnt=6;	  				
	while(1)		//delay10ms
	{
		.delay 100; 
		if(!rf_reset_cnt)
			break;

	}
	spi_data= 1; 					  //Enable RF
//	spi_sck = 0;
	rf_reset_cnt=3;    				
	while(1)		//delay 5ms to let RF stable
	{
		.delay 100; 
		if(!rf_reset_cnt)
			break;

	}				
	spi_sck = 0;			        //set SPI clock to low	
	temp00=0;
	 while(1)
	 {
		 if(rf_addr==0xff)
		 {
			break;
		 }
		 temp00++;
		 A=temp00;
		 rf_table();
		 rf_addr=A;

		 temp00++;
		 A=temp00;
		 rf_table();
		 rf_data1=A;

		 temp00++;
		 A=temp00;
		 rf_table();
		 rf_data2=A;
		 reg_write16();
	 }

 	rf_reset_cnt=6;				
	while(1)		//delay 10ms to let RF for operation
	{
		.delay 100; 
		if(!rf_reset_cnt)
			break;

	}
	rf_channel=0x20;
//	enable_recive();
}
//===============================================
//tx_rf_data
//===============================================
void rf_start_tx(void)
{
	rf_addr=00;
	rf_data1 = 0x80;
	rf_data2 = rf_channel;  // ʹ, ƵΪ 34	
	reg_write16();
}
//===============================================
//tx_rf_data
//===============================================
void rf_tx_data(void)
{  
	byte temp01_buf=1;

	flush_tx_fifo();

	rf_addr=39;
	rf_data1 = packet_length;
	rf_data2 = rf_data_buf[1];
	reg_write16();

	rf_write_data_cnt=packet_length-1;

	 point=rf_data_buf;
	 point++;
	 point++;
	 temp01_buf=0;
	 while(temp01_buf<rf_write_data_cnt)
	 {
	    rf_data1=*point;  
     //    spi_Writeabyte();
	     point++;
	     temp01_buf++;

	    rf_data2=*point;  
    //     spi_Writeabyte();
	     point++;
	     temp01_buf++;
		rf_addr=39;
		reg_write16();

	 }

	rf_start_tx();

	while(1)
	{
		rf_addr=0x16;
    	Reg_read16();
		if(rf_data2.6)
			break;

		.delay 200
	}
		.delay 2


}

//===============================================
//data_verification
//===============================================
void data_verification(void)   //У
{
	if((rf_data_buf[0]==rf_data_buf[1])&&(rf_data_buf[2]==0xaa)&&(rf_data_buf[3]==0xaa)&&(rf_data_buf[4]==0xa5))
 //  if((rf_data_buf[4]==0xa5))
   {
//	   data_code=rf_data_buf[0];
	   no_rf_delay=50;

   }
}

//===============================================
//rf_RecivePack
//===============================================
void rf_RecivePack(void)
{	
	byte len;
	byte temp01_buf=0;
	rf_addr=0x16;
	Reg_read16();
	if(rf_data2.6)
	{
		rf_reset_cnt=rf_reset_time;

		spi_csn=0;
		rf_buf=0x28+0x80;
		spi_Writeabyte();
		.delay 10
		spi_Readabyte();
		len=rf_buf;
		rf_data_buf[0]=len;

		 point=rf_data_buf;
		 point++;
		 temp01_buf=0;
		 while(temp01_buf<packet_length1)
		 {
		     rf_buf=*point;  

	         spi_Readabyte();
		     *point=rf_buf;
			 point++;
		     temp01_buf++;
		 }
		spi_csn=1;
		enable_recive();
		if(rf_data_buf[0]==packet_length1)
		{
		rf_switch();
		data_verification();
		}
	
	}

}
void Enter_Sleep(void)
{
	rf_addr=00;
	rf_data1 = 0x00;
	rf_data2 = 0x03;
	Reg_write16();	 
	rf_addr=01;
	rf_data1 = 0xa0;
	rf_data2 = 0x7f;
	Reg_write16();
	spi_csn=1;
}
void Wakeup_Sleep(void)
{
	spi_csn=0;
	rf_addr=00;
	rf_data1 = 0x00;
	rf_data2 = 0x03;
	Reg_write16();	 
	rf_addr=01;
	rf_data1 = 0x20;
	rf_data2 = 0x7f;
	Reg_write16();	
	spi_csn=0;	

	DelayCnt=200;
	Delay100US();
}
//===============================================
//Carrier_Mode
//===============================================
void carrier_mode(void)
{
	rf_addr=01;
	rf_data1 = 0x20;
	rf_data2 = 0x70;
	Reg_write16();	 

	rf_addr=0x1c;
	rf_data1 = 0x44;
	rf_data2 = 0x08;
	Reg_write16();		
	rf_start_tx();
	while(1)
	{};
}
extern byte test_mode_fg;
extern byte int_2ms;

void test_mode(void)
{	byte key_tmp=0,key_code=0;
	byte key_cnt=0;

	if(test_mode_fg==1) //زģʽ
	{
	rf_addr=01;
	rf_data1 = 0x20;
	rf_data2 = 0x70;
	Reg_write16();	 

	rf_addr=0x1c;
	rf_data1 = 0x44;
	rf_data2 = 0x08;
	Reg_write16();	
	rf_start_tx();
	}
	else
	if(test_mode_fg==2) //ģʽ
	{
	rf_start_tx();	
	}
	else
	if(test_mode_fg==3) //ģʽ
	{
	enable_recive();	
	}

	while(1)
	{
		if(!int_2ms)
		{
			int_2ms=2;
			io_led_f=1;
			key_tmp=1;
			if(pb.2) key_tmp=0;

			if(key_tmp!=key_code)	
			{
				key_code=key_tmp;
				if(key_code)
				{
				key_cnt++;
				if(key_cnt>2) key_cnt=0;
				}

				if(key_cnt==0)
				{
					rf_channel=0x03; //2405
				}
				else
				if(key_cnt==1)
				{
					rf_channel=32;  //2434
				}
				else
				if(key_cnt==2)
				{
					rf_channel=73;  //2475
				}
				set_rf_channel();

				if(test_mode_fg==3)
				{
					enable_recive();
				}
				else
				if(test_mode_fg==1)
				{
					rf_start_tx();
				}
			}

			if(test_mode_fg==2)
			{
				rf_start_tx();
			}

		}
	}


}