.global  __VECTOR_TABLE
.global  __StackTop
.global  trap_handler
.global  sys_entry

.section ".text.init"
.global reset_handler
.type reset_handler, %function
reset_handler:
    mv  x1, x0
    mv  x2, x1
    mv  x3, x1
    mv  x4, x1
    mv  x5, x1
    mv  x6, x1
    mv  x7, x1
    mv  x8, x1
    mv  x9, x1
    mv x10, x1
    mv x11, x1
    mv x12, x1
    mv x13, x1
    mv x14, x1
    mv x15, x1

    la      a0, trap_handler
    ori     a0, a0, 3
    csrw    mtvec, a0

    la      a0, __VECTOR_TABLE
    csrw    mtvt, a0

    la      sp, __StackTop
    csrw    mscratch, sp

    jal     sys_entry

    .size   reset_handler, . - reset_handler

__exit:
    j      __exit

.section ".ram_code_section"
.align 6
trap_handler:
    csrrci a0, mstatus, 8

__deadloop:
    j      __deadloop

    mret