#include "hc_config.h"
#include "omw_dbg.h"
#include "omw_svc.h"
#include "omw_rtos.h"
#include "data_xfer.h"
#include "utils/sys_timer.h"
#include "gap_def.h"
#include <string.h>
#include <stdlib.h>
#include "user_config.h"
extern struct bt_data omw_data_xfer_sc_rsp_data[];
extern struct bt_data omw_data_xfer_adv_data[];

typedef struct
{
    uint8_t bt_name[20];
    uint8_t bt_addr[6];
} USER_CONFIG_BT_INFO_T;

USER_CONFIG_BT_INFO_T user_config_bt_info;

//设备名称及地址初始化
uint8_t config_bt_name[20] = "HC BLE";
uint8_t config_bt_addr[6] = {0x33,0x12,0x33,0x44,0x45,0x55};

void user_config(void)
{


    omw_svc_set_addr(config_bt_addr);

    memcpy(user_config_bt_info.bt_name, config_bt_name, sizeof(config_bt_name));
    /**
     * @brief 配置bt名称
     *
     */
    omw_data_xfer_sc_rsp_data[0].data = user_config_bt_info.bt_name;
    omw_data_xfer_sc_rsp_data[0].type = BT_DATA_NAME_COMPLETE;
    omw_data_xfer_sc_rsp_data[0].data_len = (sizeof(user_config_bt_info.bt_name) - 1);
}
