#ifndef __HC_CNTLR_H__
#define __HC_CNTLR_H__

#include "hc_config.h"

typedef void (* host_hci_ram_rx_cb_type)(uint8_t h_tp, uint8_t * data, uint8_t len);

#ifdef OMW_BLE_CNTR_V0
#include "controller.h"
#endif

#ifdef OMW_BLE_CNTR_V2
#include "nimble_port.h"
#endif

void omw_ctrlr_init(void * cb);
void omw_base_init(void);
#ifdef OMW_HCI_H4
void omw_ctrlr_h4_rx_polling(void);
#endif

#ifdef OMW_HCI_RAM
#ifndef OMW_BLE_HOST_V0
#define HCI_NONE 0x00
#define HCI_CMD  0x01
#define HCI_ACL  0x02
#define HCI_SCO  0x03
#define HCI_EVT  0x04
#define HCI_ISO  0x05
#endif

void omw_ctrlr_hci_ram_reg_host_rx_cb(host_hci_ram_rx_cb_type h_rx_cb);
int omw_ctrlr_hci_ram_send2ctrl(uint8_t h_tp, uint8_t * data, uint8_t len);
#endif

#endif