#include "hc_config.h"

#include "pdu.h"
#include "system.h"
#include "ll_conn.h"

#ifdef OMW_EN_DEEP_SLEEP

struct ll_adv_set
{
    uint8_t is_enabled: 1;
    uint8_t adv_type: 3;

    uint8_t state;
    uint16_t interval; //unit 0.625 msec


    uint8_t chan_map: 3;
    uint8_t chan_map_curr: 3;
    uint8_t filter_policy: 2;
};

__RAM_CODE_SECTION
uint32_t ll_adv_process_wake_up()
{
    struct ll_adv_set *adv = (struct ll_adv_set *)0x20000600;
    return (adv->chan_map_curr == 0);
}
#endif
