#ifndef __HC_CONFIG_H__
#define __HC_CONFIG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include <stddef.h>
#include <stdarg.h>
//#include <string.h>
#include "user_config.h"

#define OMW_CPU_E902
#define OMW_CHIP_T1001
//#define OMW_HAS_LOG_UART
//#define OMW_CMD_CTRL
// #define OMW_ON_FPGA
#define OMW_BLE_CNTR_V0   //V2
#define OMW_BLE_HOST_V0   //V1, V2
#define OMW_HCI_RAM
// #define OMW_RTOS_LITE_SCH
 #define OMW_COMID_PATCH
// #define OMW_SVC_ERR_CHK
#define OMW_DATA_BUF_SIZE   0xA00    //KB
#define OMW_SVC_XFR_HAS_ADV_SCAN_DATA

// #define OMW_USE_STATIC_IRQ_TBL
// #define OMW_EN_FORCE_SLEEP

// #define OMW_EN_WDG
#ifdef OMW_EN_WDG
#define OMW_FEED_WDG_TIME    5
#endif

#ifdef OMW_COMID_PATCH
#define OMW_BT_CTRL_COMPANY_ID        (0x0B24)
#define OMW_BT_CTRL_SUBVERSION_NUMBER (0xABCD)
#else
#define OMW_BT_CTRL_COMPANY_ID        (0x1234)
#define OMW_BT_CTRL_SUBVERSION_NUMBER (0x5678)
#endif

#define OMW_FLASE_BASE_ADDR  0x10000000
#define OMW_FLASE_TOTAL_SIZE (256 * 1024)
#define OMW_FLASH_TAIL_RS    (16 * 1024)
#define OMW_FLASH_HAS_PE
#define OMW_FLASH_SS_BITS  12
#define OMW_FLASH_SS  (1 << OMW_FLASH_SS_BITS)
#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PS_BITS  8
#define OMW_FLASH_PS  (1 << OMW_FLASH_PS_BITS)
#else
#define OMW_FLASH_PS  OMW_FLASH_SS
#endif

#define OMW_DATA_XFER_SVR_UUID      (0xFF00)
#define OMW_DATA_XFER_SVR_WT_UUID   (0xFF01)
#define OMW_DATA_XFER_SVR_RD_UUID   (0xFF02)

#define OMW_BT_ADDR config_bt_addr
//(uint8_t[6]){0x18, 0x15, 0xE8, 0x62, 0x73, 0x34}

#define CONFIG_BT_DIS_MODEL  "T1001"
#define CONFIG_BT_DIS_MANUF  "OmniWare"
#define CONFIG_BT_DEVICE_NAME config_bt_name
#define CONFIG_BT_BUF_ACL_TX_SIZE   72
#define CONFIG_BT_BUF_ACL_TX_COUNT  2
#define CONFIG_BT_BUF_ACL_RX_SIZE   72
#define CONFIG_BT_BUF_ACL_RX_COUNT  2
#define CONFIG_BT_BUF_EVT_RX_SIZE   76
#define CONFIG_BT_BUF_EVT_RX_COUNT  2
#define CONFIG_BT_BUF_CMD_TX_SIZE   72
#define CONFIG_BT_BUF_CMD_TX_COUNT  2
#define CONFIG_BT_CTRL_RX_BUFFERS      (2)
#define CONFIG_BT_CTRL_DATA_RX_BUFFERS (2)

#define CONFIG_BT_CTRL_TX_BUFFERS      (2)
#define CONFIG_BT_CTRL_DATA_TX_BUFFERS (2)

#define CONFIG_BT_CONN        1
#define CONFIG_BT_MAX_CONN    2
#define CONFIG_BT_HCI_RESERVE 4 // must same to rom

#define OMW_EN_DEEP_SLEEP

#ifdef OMW_EN_DEEP_SLEEP
#define CONFIG_OTP_PROGRAM
//#define CONFIG_FLASH_PROGRAM

#ifdef CONFIG_FLASH_PROGRAM
#define QSPI_FLASH_FUNC_REG1_VAL 0x00190000 // PIN 10
#define QSPI_FLASH_FUNC_REG2_VAL 0x19190019 // PIN 12, 14, 15
#endif

#define OMW_GPIO_WAKEUP_MASK 0																	//zhq  note:  配置高电平唤醒脚
#define OMW_GPIO_nWAKEUP_MASK (1 << OMW_LOG_UART_RX_PIN)			//zhq  note:  配置UART RX引脚为休眠低电平唤醒脚
#define OMW_UNUSED_GPIO_MASK (0xCF2BFC)												//zhq  note: 置1失能不用的脚位
#define OMW_WHEN_SLEEP_GPIO_MASK (0x200000)											//zhq  note: 置1失能睡眠时不用的脚位
#endif

#define OMW_SAVE_UART0_REGS
#define OMW_FLASH_VDDIO_PIN1 0xff // do not use here
#define OMW_FLASH_VDDIO_PIN2 0xff // do not use here
    ////////////////////DEBUG, LOG/////////////////////////
    // #define CONFIG_BT_DEBUG
    // #define ASSERT_ENABLE

#ifdef CONFIG_BT_DEBUG
#define CONFIG_BT_LOG_LEVEL 3
#endif
    ///////////////////////////////////////////////////////

#if defined(OMW_BLE_CNTR_V0) || defined(OMW_BLE_HOST_V0)
#define OMW_BLE_V0
#endif

#if defined(OMW_RTOS_LITE_SCH)
#define OMW_HAS_SCH
#endif

//#ifdef OMW_HAS_LOG_UART
#ifdef OMW_HCI_RAM
#define OMW_LOG_UART            OMW_UART0
#define OMW_LOG_UART_RX_PIN     OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN     OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC    OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC    OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE   115200
#endif

#if defined(OMW_HCI_RAM) && defined(OMW_HCI_H4)
#error "HCI error: can not define H4 and RAM at same time!"
#endif

#if !defined(OMW_HCI_RAM) && !defined(OMW_HCI_H4)
#error "HCI error: must define one of H4 or RAM!"
#endif

#ifdef OMW_HCI_H4
#define OMW_HCI_H4_UART            OMW_UART1
#define OMW_HCI_H4_UART_RX_PIN     OMW_GPIO_PIN22
#define OMW_HCI_H4_UART_TX_PIN     OMW_GPIO_PIN23
#define OMW_HCI_H4_UART_RX_FUNC    OMW_GPIO22_UART1_RX
#define OMW_HCI_H4_UART_TX_FUNC    OMW_GPIO23_UART1_TX
#define OMW_HCI_H4_UART_BAUDRATE   115200
#endif

#if defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_HOST_V0)
#define OMW_BLE_ONLY_V0
#endif

#if (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V1)) || (defined(OMW_BLE_CNTR_V0) && defined(OMW_BLE_CNTR_V2)) || \
    (defined(OMW_BLE_CNTR_V1) && defined(OMW_BLE_CNTR_V2))
#error "can not defined two controller at same time!"
#endif

#if (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V1)) || (defined(OMW_BLE_HOST_V0) && defined(OMW_BLE_HOST_V2)) || \
    (defined(OMW_BLE_HOST_V1) && defined(OMW_BLE_HOST_V2))
#error "can not defined two host at same time!"
#endif

#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif

#ifdef __cplusplus
}
#endif

#endif


