#include <stdarg.h>

#include "bt_log.h"

#ifdef CONFIG_BT_DEBUG
void bt_log_impl_printf(uint8_t level, const char *format, ...)
{
    va_list argptr;
    va_start(argptr, format);
    DEBUG_STRING_RAW(format, argptr);
    va_end(argptr);
}

void bt_log_impl_packet(uint8_t packet_type, uint8_t in, uint8_t *packet, uint16_t len)
{
    DEBUG_HCI_H4_RAW(packet_type, in, packet, len);
}

void bt_log_impl_point(uint32_t val)
{
    DEBUG_POINT_RAW(val);
}
#endif