#ifndef __OMW_GPADC_H__
#define __OMW_GPADC_H__

#include "hc_config.h"
#include "omw_gpio.h"
#include "t1001.h"

#define OMW_GPADC_BASE GPADC_ANA_BASE


#define OMW_GPADC_EN (0x00 >> 2)
#define OMW_GPADC_CTRL (0x04 >> 2)
#define OMW_GPADC_ACTION (0X60 >> 2)
#define OMW_GPADC_CFG1 (0X64 >> 2)
#define OMW_GPADC_INT_CRTL (0X68 >> 2)
#define OMW_GPADC_SAMP (0X6C >> 2)
#define OMW_GPADC_CLK_CRTL (0X70 >> 2)
// GPADC_CTRL
// #define OMW_GPADC_INPUT_VOLTAGE_MAX_0V9 0 
// #define OMW_GPADC_INPUT_VOLTAGE_MAX_1V8 1 
// #define OMW_GPADC_INPUT_VOLTAGE_MAX_2V7 2 
// #define OMW_GPADC_INPUT_VOLTAGE_MAX_3V6 3 

#define OMW_GPADC_ATT_SEL 0 
#define OMW_GPADC_ATT_SEL_HALF 1 
#define OMW_GPADC_ATT_SEL_THIRD 2 
#define OMW_GPADC_ATT_SEL_QUARTER 3 

#define OMW_GPADC_VIN_SEL_GPIO2 0 
#define OMW_GPADC_VIN_SEL_GPIO6 1 
#define OMW_GPADC_VIN_SEL_GPIO7 2
#define OMW_GPADC_VIN_SEL_GPIO10 3 
#define OMW_GPADC_VIN_SEL_GPIO15 4 
#define OMW_GPADC_VIN_SEL_GPIO17 5 
#define OMW_GPADC_VIN_SEL_GPIO19 6 
#define OMW_GPADC_VIN_SEL_GPIO21 7 
#define OMW_GPADC_VIN_SEL_INTERNAL_REFERENCE_VOLTAGE_0V9 8 

#define OMW_GPADC_VIP_SEL_GPIO2 0
#define OMW_GPADC_VIP_SEL_GPIO6 1
#define OMW_GPADC_VIP_SEL_GPIO7 2
#define OMW_GPADC_VIP_SEL_GPIO10 3
#define OMW_GPADC_VIP_SEL_GPIO15 4
#define OMW_GPADC_VIP_SEL_GPIO17 5
#define OMW_GPADC_VIP_SEL_GPIO19 6
#define OMW_GPADC_VIP_SEL_GPIO21 7
#define OMW_GPADC_VIP_SEL_TEMPERATURE_SENSOR 8
#define OMW_GPADC_VIP_SEL_BATTERY_VOLTAGE 9
#define OMW_GPADC_VIP_SEL_CORE_INPUT_VOLTAGE 0xA
#define OMW_GPADC_VIP_SEL_CORE_SUPPLY_VOLTAGE 0XB





// GPADC_ACTION
#define OMW_GPADC_TRIG_ONE_SAMPLE 1 
#define OMW_GPADC_TRIG_CONTINUOUS 0

#define OMW_GPADC_TIMER_MODE_RISE 1
#define OMW_GPADC_TIMER_MODE_FALL 0

#define OMW_GPADC_CONT_MODE_CONTINUOUS 1
#define OMW_GPADC_CONT_MODE_SINGLE 0

#define OMW_GPADC_SAMP_EN 1
#define OMW_GPADC_SAMP_DIS 0

#define OMW_GPADC_DMA_EN 1
#define OMW_GPADC_DMA_DIS 0

// OMW_GPADC_CFG1
#define OMW_GPADC_BK_NUM_2KB 0 
#define OMW_GPADC_BK_NUM_4KB 1 
#define OMW_GPADC_BK_NUM_6KB 2 
#define OMW_GPADC_BK_NUM_8KB 3 

#define OMW_GPADC_SIGNEXT_SIGNED 1 
#define OMW_GPADC_SIGNEXT_UNSIGNED 0

#define OMW_GPADC_FORMAT_BINARY 1
#define OMW_GPADC_FORMAT_SIGNED_TWO_COMPLEMENT 0

#define OMW_GPADC_STORE_MODE_32BIT 1
#define OMW_GPADC_STORE_MODE_16BIT 0

// OMW_GPADC_CLK_CRTL
#define OMW_GPADC_CLK_OUT_POL_HIGH 1
#define OMW_GPADC_CLK_OUT_POL_LOW 0

#define OMW_GPADC_CLK_OUT_INV_INVERT 1
#define OMW_GPADC_CLK_OUT_INV_NORMAL 0

#define OMW_GPADC_CLK_SAMP_INV_RISE 1
#define OMW_GPADC_CLK_SAMP_INV_FALL 0

#define OMW_GPADC_CLK_AUTOCG_EN 1
#define OMW_GPADC_CLK_AUTOCG_DIS 0

#define OMW_GPADC_CLK_SEL_RC24M 0
#define OMW_GPADC_CLK_SEL_XTAL24M 1

typedef struct 
{
   uint32_t gpadc_att_sel;
   uint32_t gpadc_diff_en;
   uint32_t gpadc_vin_sel;
   uint32_t gpadc_vip_sel;

   uint32_t gpadc_avg_win;
   uint32_t gpadc_timer_sel;
   uint32_t gpadc_timer_mode;
   uint32_t gpadc_cont_mode;
   uint32_t gpadc_samp_en;
   uint32_t gpadc_dma_en;

   uint32_t gpadc_int_interval;
   uint32_t gpadc_bk_num;
   uint32_t gpadc_start_bk;
   uint32_t gpadc_signext;
   uint32_t gpadc_format;
   uint32_t gpadc_store_mode;

   uint32_t gpadc_clk_pre;
   uint32_t gpadc_clk_div;
   uint32_t gpadc_clk_out_pol;
   uint32_t gpadc_clk_out_inv;
   uint32_t gpadc_clk_samp_inv;
   uint32_t gpadc_clk_en;
   uint32_t gpadc_clk_autocg;
   uint32_t gpadc_clk_sel;
}GPADC_InitTypeDef;






void omw_gpadc_init( GPADC_InitTypeDef* ADC_InitStruct, uint32_t* gpadc_base_addr);
void omw_gpadc_structinit(GPADC_InitTypeDef* ADC_InitStruct);
void omw_gpadc_cmd(FunctionalState NewState, uint32_t* gpadc_base_addr);
void omw_gpadc_itconfig(FunctionalState NewState,uint32_t* gpadc_base_addr);
void omw_gpadc_dma_itconfig(FunctionalState NewState,uint32_t* gpadc_base_addr);
uint16_t omw_gpadc_get_dma_point(void);
FlagStatus omw_gpadc_get_itstatus(void);
FlagStatus omw_gpadc_get_dma_itstatus(void);
uint32_t omw_gpadc_get_samp(void);


void omw_gpadc_single_init(GPADC_InitTypeDef * ADC_InitStruct,uint32_t * gpadc_base_addr);
void omw_gpadc_continuous_init(GPADC_InitTypeDef * ADC_InitStruct,uint32_t * gpadc_base_addr);
void omw_gpadc_continuous_dma_init(GPADC_InitTypeDef * ADC_InitStruct,uint32_t * gpadc_base_addr);






#endif

     