#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "t1001_it.h"
#include "periph_gpio.h"
#include "periph_gpadc.h"
#include "periph_timer.h"
#include "t1002_otp_cfg.h"

ATTRIBUTE_ISR void TIMER1_Handler(void)
{
    if (GPIO_ReadOutputDataBit(GPIO_PIN_2))
    {
        GPIO_ResetBits(GPIO_PIN_2);
    }
    else
    {
        GPIO_SetBits(GPIO_PIN_2);
    }
    TIMER_ClearITPendingBit(TIMER1);
}


ATTRIBUTE_ISR void TIMER7_Handler(void)
{
    if (GPIO_ReadOutputDataBit(GPIO_PIN_4))
    {
        GPIO_ResetBits(GPIO_PIN_4);
    }
    else
    {
        GPIO_SetBits(GPIO_PIN_4);
    }
    TIMER_ClearITPendingBit(TIMER7);
}
int main()
{
    omw_set_irq_prio(TIMER1_IRQn,3);
    omw_enable_irq(TIMER1_IRQn);
    omw_set_irq_prio(TIMER7_IRQn,3);
    omw_enable_irq(TIMER7_IRQn);	

    TIMER_InitTypeDef TIMER_InitStruct;
    GPIO_InitTypeDef GPIO_InitStruct;

    // init
    omw_dbg_init();
    printf("TIMER test ...\n");
    
    //初始化GPIO
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = (GPIO_PIN_2 | GPIO_PIN_4);
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUT_PP;
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
    GPIO_Init(&GPIO_InitStruct);
    // GPIO_SetBits(GPIO_PIN_2);
    // GPIO_ResetBits(GPIO_PIN_3);


    TIMER_StructInit(&TIMER_InitStruct);
    //TIMER1每5ms进入中断翻转一次GPIO2
    TIMER_InitStruct.TIMER_CLKSelect = TIMER_CLK_SEL_PLL48M;
    TIMER_InitStruct.TIMER_CLKDivide = TIMER_CLK_DIVIDE_8;
    TIMER_InitStruct.TIMER_PWMCmd = DISABLE;
    TIMER_InitStruct.TIMER_Mode = TIMER_MODE_USER_DEFINED;
    TIMER_InitStruct.TIMER_Loadcount = 30000;
    TIMER_Init(TIMER1, &TIMER_InitStruct);
    TIMER_ITCmd(TIMER1, ENABLE);
    TIMER_Cmd(TIMER1, ENABLE);
    //TIMER7每20ms进入中断翻转一次GPIO4
    TIMER_InitStruct.TIMER_CLKSelect = TIMER_CLK_SEL_XTAL24M;
	TIMER_InitStruct.TIMER_CLKDivide = TIMER_CLK_DIVIDE_16;
    TIMER_InitStruct.TIMER_Loadcount = 30000;
    TIMER_Init(TIMER7, &TIMER_InitStruct);
    TIMER_ITCmd(TIMER7, ENABLE);
    TIMER_Cmd(TIMER7, ENABLE);

    while(1);
}





