#ifndef __PERIPH_SPIM_H__
#define __PERIPH_SPIM_H__

#include "t1001.h"

#define SPIM1_BASE        0x41004000UL
#define SPIM0            SPIM
#define SPIM1            ((SPIM_Type*) SPIM1_BASE)

typedef struct
{
    uint32_t SPIM_Direction;

    uint32_t SPIM_SCPOL;                

    uint32_t SPIM_SCPH;
 
    uint32_t SPIM_BaudRatePrescaler;   // 波特率分频只能为偶数，范围 2 ~ 65534, 时钟源和CPU时钟频率一样
	
    uint32_t SPIM_RxFIFOThreshold;
	
    uint32_t SPIM_TxFIFOThreshold;
	
    uint32_t SPIM_Wires;

}SPIM_InitTypeDef;

//SPIM Direction mode
#define SPIM_DIRECTION_TX_AND_RX   (uint32_t)0x0000    //全双工模式；发一字节，同时收一字节  
#define SPIM_DIRECTION_TX_ONLY     (uint32_t)0x0100    //仅发送
#define SPIM_DIRECTION_RX_ONLY     (uint32_t)0x0200    //写TxFIFO触发收一字节，实际不发送



//SPIM Clock Polarity
#define SPIM_SCPOL_LOW   (uint32_t)0x0000  
#define SPIM_SCPOL_HIGH  (uint32_t)0x0080


//SPIM Clock Phase
#define SPIM_SCPH_MIDDLE  (uint32_t)0x0000
#define SPIM_SCPH_START   (uint32_t)0x0040


//SPIM WIRES
#define SPIM_WIRES_4    (uint32_t)0x00
#define SPIM_WIRES_3    (uint32_t)0x02


//SPIM Status Flag
#define SPIM_FLAG_DATA_COLLISION_ERROR    (uint8_t)0x40 
#define SPIM_FLAG_TRANSMISSION_ERROR      (uint8_t)0x20
#define SPIM_FLAG_RECEIVE_FIFO_FULL       (uint8_t)0x10
#define SPIM_FLAG_RECEIVE_FIFO_NOT_EMPTY  (uint8_t)0x08
#define SPIM_FLAG_TRANSMIT_FIFO_EMPTY     (uint8_t)0x04
#define SPIM_FLAG_TRANSMIT_FIFO_NOT_FULL  (uint8_t)0x02
#define SPIM_FLAG_BUSY                    (uint8_t)0x01

//SPIM Interrupt
#define SPIM_IT_MULTI_MASTER_CONTENTION   (uint8_t)0x20
#define SPIM_IT_RX_FIFO_FULL              (uint8_t)0x10
#define SPIM_IT_RX_FIFO_OVERFLOW          (uint8_t)0x08
#define SPIM_IT_RX_FIFO_UNDERFLOW         (uint8_t)0x04
#define SPIM_IT_TX_FIFO_OVERFLOW          (uint8_t)0x02
#define SPIM_IT_TX_FIFO_EMPTY             (uint8_t)0x01
#define SPIM_IT_ALL                       (uint8_t)0x3F

//SPIM FRAME DATA
#define SPIM_DATA_SIZE_8BITS    (uint32_t)0x0007

//SPIM Frame Format
#define SPIM_FRF_MOTOROLA_SPI   (uint32_t)0x0000         //Motorolla SPI Frame Format



//SPIM Function
void SPIM_DeInit(SPIM_Type* SPIx);
void SPIM_StructInit(SPIM_InitTypeDef* SPI_InitStruct);
void SPIM_Init(SPIM_Type* SPIx, SPIM_InitTypeDef* SPI_InitStruct);
void SPIM_Cmd(SPIM_Type* SPIx, FunctionalState NewState);
void SPIM_RecviveLengthConfig(SPIM_Type* SPIx, uint8_t RxLen);        // RxLen 实际长度，备注RX_ONLY模式配置接收长度，仅用在触发一次，接收多个字节的情况！！！
void SPIM_SendData(SPIM_Type* SPIx, uint8_t Data);
uint8_t SPIM_ReceiveData(SPIM_Type* SPIx);
FlagStatus SPIM_GetUsrStatus(SPIM_Type* SPIx, uint8_t Flag);
void SPIM_ITConfig(SPIM_Type* SPIx, uint8_t SPIM_IT, FunctionalState NewState);
ITStatus SPIM_GetITStatus(SPIM_Type* SPIx, uint8_t SPIM_IT);
void SPIM_Direction_Switch(SPIM_Type* SPIx, uint32_t SPIM_Direction);

#endif
