#ifndef __PERIPH_TIMER_H__
#define __PERIPH_TIMER_H__

#include "t1001.h"


#define TIMER_LOAD_COUNT_OFFSET_BASE     (TIMER_BASE + 0x00)
#define TIMER_CURRENT_COUNT_BASE         (TIMER_BASE + 0x04)
#define TIMER_CONTROL_BASE               (TIMER_BASE + 0x08)
#define TIMER_CLR_IT_STATUS_BASE         (TIMER_BASE + 0x0C)
#define TIMER_IT_STATUS_BASE             (TIMER_BASE + 0x10)

#define TIMER_LOAD_COUNT2_BASE          (TIMER_BASE + 0XB0)


#define TIMER0   0x00
#define TIMER1   0x01
#define TIMER2   0x02
#define TIMER3   0x03
#define TIMER4   0x04
#define TIMER5   0x05
#define TIMER6   0x06
#define TIMER7   0x07

	
#define TIMER_MODE_USER_DEFINED  (0x02)   //0 ~ TIMER Loadcount 循环计数(PWM 0~100%使能后，会再进行0 ~ TIMER Loadcount2计数) 
#define TIMER_MODE_FREE_RUNNING  (0x00)   //0 ~ 0xffff 循环计数


#define TIMER_CLK_SEL_XTAL24M   0X00
#define TIMER_CLK_SEL_RC24M     0x01
#define TIMER_CLK_SEL_PLL48M    0x02


#define TIMER_CLK_DIVIDE_2      0X00
#define TIMER_CLK_DIVIDE_4      0x01
#define TIMER_CLK_DIVIDE_8      0x02
#define TIMER_CLK_DIVIDE_16     0x03
#define TIMER_CLK_DIVIDE_32     0x04
#define TIMER_CLK_DIVIDE_64     0x05
#define TIMER_CLK_DIVIDE_128    0x06
#define TIMER_CLK_DIVIDE_256    0x07
#define TIMER_CLK_DIVIDE_512    0x08
#define TIMER_CLK_DIVIDE_1024   0x09
#define TIMER_CLK_DIVIDE_2048   0x0A
#define TIMER_CLK_DIVIDE_4096   0x0B
#define TIMER_CLK_DIVIDE_NONE   0x0C


typedef struct
{
	uint8_t TIMER_Mode;             //选择计时器工作模式，计时结束后选择装载TimerXLoadCount中的值或者默认装载最大值0xffff

	FunctionalState TIMER_PWMCmd; 	        //TIMER用作PWM输出时使能
	
	FunctionalState TIMER_PWM0N100Cmd;      //失能该位使能后，PWM占空比无法调节到0%或100%；计时器模式下配置无意义
	
	uint16_t TIMER_Loadcount;       //计时器模式下重装载寄存器周期的值，它的取值必须在0x0000和0xFFFF之间；PWM模式下设置低电平周期的值          
	
	uint16_t TIMER_Loadcount2;      //计时器模式下配置无意义；PWM模式下设置高电平周期的值，它的取值必须在0x0000和0xFFFF之间
	
	uint16_t TIMER_CLKSelect;       //计时器模块时钟选择
	
	uint32_t TIMER_CLKDivide;       //计时器模块时钟分频选择
}TIMER_InitTypeDef;

void TIMER_DeInit(uint16_t TIMERx);
void TIMER_Init(uint16_t TIMERx, TIMER_InitTypeDef* TIMER_InitStruct);
void TIMER_StructInit(TIMER_InitTypeDef* TIMER_InitStruct);
void TIMER_Cmd(uint16_t TIMERx, FunctionalState NewState);
FlagStatus TIMER_GetFlagStatus(uint16_t TIMERx);
uint8_t TIMER_GetAllFlagStatus(void);
void TIMER_ClearFlag(uint16_t TIMERx);
void TIMER_ClearAllFlag(void);
void TIMER_ITCmd(uint16_t TIMERx, FunctionalState NewState);
ITStatus TIMER_GetITStatus (uint16_t TIMERx);
uint8_t TIMER_GetAllITStatus(void);
void TIMER_ClearITPendingBit(uint16_t TIMERx);
void TIMER_ClearAllITPendingBit(void);
void TIMER_SetLoadCount(uint16_t TIMERx, uint16_t LoadCount, uint16_t LoadCount2);  //快速切换PWM占空比
#endif


