#ifndef __SIMPLE_RAM_POOL_H__
#define __SIMPLE_RAM_POOL_H__

#include <stdint.h>
#include "stddef.h"

typedef struct {
    uint8_t* base_addr;
    uint16_t total_len;
    uint16_t offset;
} simple_ram_pool_t;

// static inline void simple_ram_pool_init(simple_ram_pool_t* pool, uint8_t* base_addr, uint16_t total_len)
// {
//     pool->base_addr = base_addr;
//     pool->total_len = total_len;
//     pool->offset = 0;
// }

// static inline uint8_t* simple_ram_pool_malloc(simple_ram_pool_t* pool, uint16_t size)
// {
//     uint16_t offset = pool->offset;
//     pool->offset += size;
//     if(pool->offset > pool->total_len)
//     {
//         return NULL;
//     }

//     return pool->base_addr + offset;
// }

void simple_ram_pool_init(simple_ram_pool_t* pool, uint8_t* base_addr, uint16_t total_len);
uint8_t* simple_ram_pool_malloc(simple_ram_pool_t* pool, uint16_t size);

#endif