#ifndef __OMW_GPIO_H__
#define __OMW_GPIO_H__

#include "omw_config.h"
#include <t1001_gpio.h>

struct gpio_cfg_tag
{
    uint8_t   id;
    uint8_t   cfg;
};


void omw_gpio_set_func(OMW_ENUM_GPIO_PIN pin, uint32_t cfg_val);
void omw_gpio_set_func_ex(const struct gpio_cfg_tag * pcfg, int pins);
void omw_gpio_init(OMW_ENUM_GPIO_PIN pin,OMW_ENUM_GPIO_MODE mode,OMW_ENUM_GPIO_DRIVE_STRENTH drive_strenth);
uint8_t omw_gpio_read_input_data(OMW_ENUM_GPIO_PIN pin);
uint32_t omw_gpio_read_input_data_all(void);
uint8_t omw_gpio_read_output_data(OMW_ENUM_GPIO_PIN pin);
uint32_t omw_gpio_read_output_data_all(void);
void omw_gpio_set_output_en(OMW_ENUM_GPIO_PIN pin,FunctionalState state);
void omw_gpio_set_output(OMW_ENUM_GPIO_PIN pin, lineStatus flag);
void omw_gpio_set_it(OMW_ENUM_GPIO_PIN pin,OMW_GPIO_IT GPIO_IT,FunctionalState NewState);
void omw_gpio_set_it_en(OMW_ENUM_GPIO_PIN pin,FunctionalState NewState);
ITStatus omw_gpio_get_it_status(OMW_ENUM_GPIO_PIN pin);
void omw_gpio_it_flag_clr(OMW_ENUM_GPIO_PIN pin);

#endif
