#ifndef __OMW_CONFIG_H__
#define __OMW_CONFIG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include <stddef.h>
#include <stdarg.h>
#include <string.h>

#define OMW_CPU_E902
#define OMW_CHIP_T1001
#define OMW_HAS_LOG_UART
#define OMW_MCU_ONLY
#define OMW_CLTR_SLEEP_TEST
//#define OMW_CMD_CTRL
//#define OMW_SPIM0
//#define OMW_SPIM1
//#define OMW_SPIS
//#define OMW_IIC
//#define OMW_TIMER
//#define OMW_SDMA
//#define OMW_GPADC
//#define OMW_WDT
//#define OMW_GPIO
//#define OMW_AD
//#define OMW_SYS
//#define OMW_FLASH_UID
//#define OMW_INTR
//#define OMW_CLKCAL

#define OMW_USE_STATIC_IRQ_TBL

#define OMW_FLASH_HAS_PE
#define OMW_FLASH_SS_BITS  12
#define OMW_FLASH_SS  (1 << OMW_FLASH_SS_BITS)
#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PS_BITS  8
#define OMW_FLASH_PS  (1 << OMW_FLASH_PS_BITS)
#else
#define OMW_FLASH_PS  OMW_FLASH_SS
#endif

#define OMW_BLE_ONLY_V0

#ifdef OMW_HAS_LOG_UART
#define OMW_LOG_UART            OMW_UART0
#define OMW_LOG_UART_RX_PIN     OMW_GPIO_PIN20
#define OMW_LOG_UART_TX_PIN     OMW_GPIO_PIN21
#define OMW_LOG_UART_RX_FUNC    OMW_GPIO20_UART0_RX
#define OMW_LOG_UART_TX_FUNC    OMW_GPIO21_UART0_TX
#define OMW_LOG_UART_BAUDRATE   115200
#endif

#ifdef OMW_CMD_CTRL
#define OMW_CMD_CTRL_UART            OMW_UART1
#define OMW_CMD_CTRL_UART_RX_PIN     OMW_GPIO_PIN22
#define OMW_CMD_CTRL_UART_TX_PIN     OMW_GPIO_PIN23
#define OMW_CMD_CTRL_UART_RX_FUNC    OMW_GPIO22_UART1_RX
#define OMW_CMD_CTRL_UART_TX_FUNC    OMW_GPIO23_UART1_TX
#define OMW_CMD_CTRL_UART_BAUDRATE   115200
#define OMW_CMD_CTRL_EN_IT_RX
#endif

#ifdef OMW_SPIS
#define OMW_SPIS_PIN_NCS         (OMW_GPIO_PIN16)
#define OMW_SPIS_PIN_SCK         (OMW_GPIO_PIN17)
#define OMW_SPIS_PIN_MISO        (OMW_GPIO_PIN23)
#define OMW_SPIS_PIN_MOSI        (OMW_GPIO_PIN22)
#define OMW_SPIS_FUN_CFG_NCS     ((0x3 << 3) | OMW_GPIO16_SPIS0_NCS)
#define OMW_SPIS_FUN_CFG_SCK     ((0x3 << 3) | OMW_GPIO17_SPIS0_SCK)
#define OMW_SPIS_FUN_CFG_MISO    ((0x3 << 3) | OMW_GPIO23_SPIS0_MISO)
#define OMW_SPIS_FUN_CFG_MOSI    ((0x3 << 3) | OMW_GPIO22_SPIS0_MOSI)
#endif

#ifdef OMW_SPIM0
#define OMW_SPIM0_PIN_NCS         (OMW_GPIO_PIN8)
#define OMW_SPIM0_PIN_SCK         (OMW_GPIO_PIN9)
#define OMW_SPIM0_PIN_MOSI        (OMW_GPIO_PIN18)
#define OMW_SPIM0_PIN_MISO        (OMW_GPIO_PIN19)
#define OMW_SPIM0_FUN_CFG_NCS     ((0x3 << 3) | OMW_GPIO8_SPIM0_NCS)
#define OMW_SPIM0_FUN_CFG_SCK     ((0x3 << 3) | OMW_GPIO9_SPIM0_SCK)
#define OMW_SPIM0_FUN_CFG_MOSI    ((0x3 << 3) | OMW_GPIO18_SPIM0_MOSI)
#define OMW_SPIM0_FUN_CFG_MISO    ((0x3 << 3) | OMW_GPIO19_SPIM0_MISO)
#endif

#ifdef OMW_SPIM1
#define OMW_SPIM1_PIN_NCS         (OMW_GPIO_PIN4)
#define OMW_SPIM1_PIN_SCK         (OMW_GPIO_PIN5)
#define OMW_SPIM1_PIN_MOSI        (OMW_GPIO_PIN6)
#define OMW_SPIM1_PIN_MISO        (OMW_GPIO_PIN7)
#define OMW_SPIM1_FUN_CFG_NCS     ((0x3 << 3) | OMW_GPIO5_SPIM1_NCS)
#define OMW_SPIM1_FUN_CFG_SCK     ((0x3 << 3) | OMW_GPIO4_SPIM1_SCK)
#define OMW_SPIM1_FUN_CFG_MOSI    ((0x3 << 3) | OMW_GPIO6_SPIM1_MOSI)
#define OMW_SPIM1_FUN_CFG_MISO    ((0x3 << 3) | OMW_GPIO7_SPIM1_MISO)
#endif
#ifdef OMW_TIMER
#define OMW_TIMER_PIN_PWM0_1        (OMW_GPIO_PIN0)
#define OMW_TIMER_PIN_PWM1_1        (OMW_GPIO_PIN1)
#define OMW_TIMER_PIN_PWM2_1        (OMW_GPIO_PIN2)
#define OMW_TIMER_PIN_PWM3_1        (OMW_GPIO_PIN3)
#define OMW_TIMER_PIN_PWM4_1        (OMW_GPIO_PIN4)
#define OMW_TIMER_PIN_PWM5_1        (OMW_GPIO_PIN5)
#define OMW_TIMER_PIN_PWM6_1        (OMW_GPIO_PIN6)
#define OMW_TIMER_PIN_PWM7_1        (OMW_GPIO_PIN7)
#define OMW_TIMER_PIN_PWM0_2        (OMW_GPIO_PIN8)
#define OMW_TIMER_PIN_PWM0_N        (OMW_GPIO_PIN9)
#define OMW_TIMER_PIN_PWM1_2        (OMW_GPIO_PIN10)
#define OMW_TIMER_PIN_PWM1_N        (OMW_GPIO_PIN11)
#define OMW_TIMER_PIN_PWM2_2        (OMW_GPIO_PIN12)
#define OMW_TIMER_PIN_PWM2_N        (OMW_GPIO_PIN13)
#define OMW_TIMER_PIN_PWM3_2        (OMW_GPIO_PIN14)
#define OMW_TIMER_PIN_PWM3_N        (OMW_GPIO_PIN15)
#define OMW_TIMER_PIN_PWM4_2        (OMW_GPIO_PIN16)
#define OMW_TIMER_PIN_PWM4_N        (OMW_GPIO_PIN17)
#define OMW_TIMER_PIN_PWM5_2        (OMW_GPIO_PIN18)
#define OMW_TIMER_PIN_PWM5_N        (OMW_GPIO_PIN19)
#define OMW_TIMER_PIN_PWM6_2        (OMW_GPIO_PIN20)
#define OMW_TIMER_PIN_PWM6_N        (OMW_GPIO_PIN21)
#define OMW_TIMER_PIN_PWM7_2        (OMW_GPIO_PIN22)
#define OMW_TIMER_PIN_PWM7_N        (OMW_GPIO_PIN23)
#define OMW_TIMER_FUN_CFG_PWM0    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM1    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM2    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM3    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM4    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM5    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM6    ((0x3 << 3) | 7)
#define OMW_TIMER_FUN_CFG_PWM7    ((0x3 << 3) | 7)
#endif
#ifdef OMW_IIC
#define OMW_IIC_PIN_SCL           (OMW_GPIO_PIN22)
#define OMW_IIC_PIN_SDA           (OMW_GPIO_PIN23)
#define OMW_IIC_FUN_CFG_SCL       ((0x3 << 3) | OMW_GPIO22_I2C0_SCL)
#define OMW_IIC_FUN_CFG_SDA       ((0x3 << 3) | OMW_GPIO23_I2C0_SDA)
#endif

#ifdef OMW_CHIP_T1001
#include "t1001.h"
#endif

#ifdef OMW_HAS_SCH
#include "omw_rtos.h"
#endif

#ifdef __cplusplus
}
#endif

#endif
