# AVRCP协议

demo支持AVRCP协议V1.0

- **v1.0**：基本的远程控制命令，如播放、暂停、切歌、增大/减小音量

## 工程配置

### 开启日志打印

- 使能omw_config.h中的OMW_HAS_LOG_UART

- 使能btstack_config.h中ENABLE_PRINTF_HEXDUMP

- 在embedded文件中添加hci_dump_embedded_stdout.c

### 关闭日志打印

- 屏蔽omw_config.h中的OMW_HAS_LOG_UART

- 屏蔽btstack_config.h中ENABLE_PRINTF_HEXDUMP

- 移除embedded文件中添加hci_dump_embedded_stdout.c

### 修改蓝牙配置

#### 修改名称

蓝牙名称需要修改两个地方hog_avrcp_demo.c以及hog_avrcp_demo.h文件

hog_avrcp_demo.c文件

![image-20250121135146138](README.assets/image-20250121135146138.png)

0x0a=蓝牙名称长度+1

hog_avrcp_demo.h文件

![image-20250121135946531](README.assets/image-20250121135946531.png)

0x11=蓝牙名称长度+8

#### 修改地址

omw_config.h文件

![image-20250121140106104](README.assets/image-20250121140106104.png)



#### 修改广播间隔

hog_avrcp_demo.c文件

```c
uint16_t adv_int_min = 0x0030;
uint16_t adv_int_max = 0x0030;
```

#### 开启/关闭广播

- 开启 gap_advertisements_enable(1);
- 关闭 gap_advertisements_enable(0);

### 开启/关闭看门狗

在omw_config.h中使能OMW_EN_WDG

## 使用说明

### 连接过程

#### 安卓

安卓设备点击连接后等待片刻会出现配对请求，点击配对，等待连接成功。

<img src="README.assets/IMG_3242.JPG" alt="IMG_3242" style="zoom: 25%;" />

连接成功如下图所示

<img src="README.assets/IMG_3243.JPG" alt="IMG_3243" style="zoom:25%;" />

#### IOS

ios设备点击连接后，会显示“已连接”标识，等待片刻会显示配对请求

<img src="README.assets/IMG_3239.PNG" alt="IMG_3239" style="zoom:25%;" />

点击配对等待连接完成

<img src="README.assets/IMG_3240.PNG" alt="IMG_3240" style="zoom:25%;" />

连接完成如下图所示

<img src="README.assets/IMG_3241.PNG" alt="IMG_3241" style="zoom:25%;" />

### 按键功能

| 按键名称 | 按下方式 |       功能       | 唤醒设备回连 |
| :------: | :------: | :--------------: | :----------: |
|   KEY1   |  长按3s  | 开启蓝牙配对模式 |      √       |
|   KEY1   |   单击   |      上一曲      |      √       |
|   KEY2   |   单击   |      下一曲      |      √       |
|   KEY3   |   单击   |     增大音量     |      √       |
|   KEY4   |   单击   |     减小音量     |      √       |
|   KEY4   |   双击   |    播放/暂停     |      √       |

### 背光功能

| PIN   | 闪烁方式       | 触发方式         |      |
| ----- | -------------- | ---------------- | ---- |
| GPIO3 | 1HZ闪烁 3S时长 | 任意一个按键按下 |      |

如果需要增删改查按键功能对avrcp_key进行修改即可。

```c
avrcp_key_t avrcp_key[NUMBER_OF_KEYS] = {
    {"Key 1", OMW_GPIO_PIN6, SINGLE_CLICK, HIGH_LEVEL, LOW_LEVEL, 0, 0, key1_callback},
    {"Key 2", OMW_GPIO_PIN7, SINGLE_CLICK, HIGH_LEVEL, LOW_LEVEL, 0, 0, key2_callback},
    {"Key 3", OMW_GPIO_PIN8, SINGLE_CLICK, HIGH_LEVEL, LOW_LEVEL, 0, 0, key3_callback},
    {"Key 4", OMW_GPIO_PIN9, SINGLE_CLICK | DOUBLE_CLICK, HIGH_LEVEL, LOW_LEVEL, 0, 0, key4_callback}};
```

### 注意说明

当有新设备进行首次配对连接时：

- 请断开正在连接的设备，并关闭设备蓝牙（例：断开和手机的连接，关闭手机蓝牙）
- 长按KEY1 3s 以上开启蓝牙广播功能（不开启此功能可能导致配对失败）
- 建议鸿蒙4.0以上设备在回连不上时，采用长按KEY1 3s后再进行连接

