#ifndef __OMW_UART_H__
#define __OMW_UART_H__

#include "omw_config.h"
#include "omw_gpio.h"

#ifdef OMW_CHIP_T1001
#include <t1001_uart.h>
#endif

typedef enum
{
    OMW_UART_CLK_RC24M    =0,
	OMW_UART_CLK_XTAL24M  =1,
	OMW_UART_CLK_DPLL48M  =2
}OMW_UART_CLK;

void omw_uart_clk_set( OMW_UART_CLK uart_clk);
void omw_uart_set_baudrate(uint32_t *uart_base_addr, uint32_t cfg_val);
void omw_uart_init(uint32_t *uart_base_addr, uint32_t baudrate, uint32_t rx_it_mode);
void omw_uart_send(uint32_t *uart_base_addr, void * pdata, uint32_t len);
uint32_t omw_uart_rcv(uint32_t *uart_base_addr, void * pbuf, uint32_t blen);

//fifo_sz must be 2^n
void omw_uart_set_rx_fifo(uint32_t *uart_base_addr, uint8_t * fifo_buf, uint16_t fifo_sz);
uint16_t omw_uart_get_rx_fifo_wt(uint32_t *uart_base_addr);
void omw_uart_set_rx_fifo_rd(uint32_t *uart_base_addr, uint16_t n_rd);
void omw_uart_it_rx_by_base_addr(uint32_t * uart_base_addr);

#endif
