#ifndef __T1001_GPIO_H__
#define __T1001_GPIO_H__

#include "t1001.h"

typedef enum
{
    OMW_GPIO_PIN0 = 0x00,
    OMW_GPIO_PIN1,
    OMW_GPIO_PIN2,
    OMW_GPIO_PIN3,
    OMW_GPIO_PIN4,
    OMW_GPIO_PIN5,
    OMW_GPIO_PIN6,
    OMW_GPIO_PIN7,
    OMW_GPIO_PIN8,
    OMW_GPIO_PIN9,
    OMW_GPIO_PIN10,
    OMW_GPIO_PIN11,
    OMW_GPIO_PIN12,
    OMW_GPIO_PIN13,
    OMW_GPIO_PIN14,
    OMW_GPIO_PIN15,
    OMW_GPIO_PIN16,
    OMW_GPIO_PIN17,
    OMW_GPIO_PIN18,
    OMW_GPIO_PIN19,
    OMW_GPIO_PIN20,
    OMW_GPIO_PIN21,
    OMW_GPIO_PIN22,
    OMW_GPIO_PIN23,
}OMW_ENUM_GPIO_PIN;

typedef enum
{
    OMW_GPIO_MODE_IN_FLOATING    = 0x00 ,
    OMW_GPIO_MODE_IN_PULL_UP     = 0x20 ,
    OMW_GPIO_MODE_IN_PULL_DOWN   = 0x40,
    OMW_GPIO_MODE_ANALOG         = 0x60 ,
    OMW_GPIO_MODE_OP_DRAIN       = 0x80,
}OMW_ENUM_GPIO_MODE;

typedef enum
{
    OMW_GPIO_DRIVE_STRENTH0 = 0x00 ,
    OMW_GPIO_DRIVE_STRENTH1 = 0x01 ,
    OMW_GPIO_DRIVE_STRENTH2 = 0x02 ,
    OMW_GPIO_DRIVE_STRENTH3 = 0x03 ,
}OMW_ENUM_GPIO_DRIVE_STRENTH;

typedef enum
{
    OMW_GPIO0_GPIO     = 0,
    OMW_GPIO1_GPIO     = 0,
    OMW_GPIO2_GPIO     = 0,
    OMW_GPIO3_GPIO     = 0,
    OMW_GPIO4_GPIO     = 0,
    OMW_GPIO5_GPIO     = 0,
    OMW_GPIO6_GPIO     = 0,
    OMW_GPIO7_GPIO     = 0,
    OMW_GPIO8_GPIO     = 0,
    OMW_GPIO9_GPIO     = 0,
    OMW_GPIO10_GPIO    = 0,
    OMW_GPIO11_GPIO    = 0,
    OMW_GPIO12_GPIO    = 0,
    OMW_GPIO13_GPIO    = 0,
    OMW_GPIO14_GPIO    = 0,
    OMW_GPIO15_GPIO    = 0,
    OMW_GPIO16_GPIO    = 0,
    OMW_GPIO17_GPIO    = 0,
    OMW_GPIO18_GPIO    = 0,
    OMW_GPIO19_GPIO    = 0,
    OMW_GPIO20_GPIO    = 0,
    OMW_GPIO21_GPIO    = 0,
    OMW_GPIO22_GPIO    = 0,
    OMW_GPIO23_GPIO    = 0,

    OMW_GPIO0_JTAG_TCLK    = 1,
    OMW_GPIO1_JTAG_TMS     = 1,
    OMW_GPIO2_JTAG_TRSTB   = 1,
    OMW_GPIO3_CLK_24M      = 1,
    OMW_GPIO4_QSPI_CLK     = 1,
    OMW_GPIO5_QSPI_NCS     = 1,
    OMW_GPIO6_QSPI_D0      = 1,
    OMW_GPIO7_QSPI_D1      = 1,
    OMW_GPIO8_QSPI_D2      = 1,
    OMW_GPIO9_QSPI_D3      = 1,
    OMW_GPIO10_QSPI_CLK    = 1,
    OMW_GPIO11_QSPI_NCS    = 1,
    OMW_GPIO12_QSPI_D0     = 1,
    OMW_GPIO13_QSPI_D1     = 1,
    OMW_GPIO14_QSPI_D2     = 1,
    OMW_GPIO15_QSPI_D3     = 1,
    OMW_GPIO16_QSPI_CLK    = 1,
    OMW_GPIO17_QSPI_NCS    = 1,
    OMW_GPIO18_QSPI_D0     = 1,
    OMW_GPIO19_QSPI_D1     = 1,
    OMW_GPIO20_QSPI_D2     = 1,
    OMW_GPIO21_QSPI_D3     = 1,
    OMW_GPIO22_I2C0_SCL    = 1,
    OMW_GPIO23_I2C0_SDA    = 1,

    OMW_GPIO0_I2C0_SCL     = 2,
    OMW_GPIO1_I2C0_SDA     = 2,
    OMW_GPIO2_UART0_RX     = 2,
    OMW_GPIO3_UART0_TX     = 2,
    OMW_GPIO4_UART1_RX     = 2,
    OMW_GPIO5_UART1_TX     = 2,
    OMW_GPIO6_I2C0_SCL     = 2,
    OMW_GPIO7_I2C0_SDA     = 2,
    OMW_GPIO8_UART0_RX     = 2,
    OMW_GPIO9_UART0_TX     = 2,
    OMW_GPIO10_UART1_RX    = 2,
    OMW_GPIO11_UART1_TX    = 2,
    OMW_GPIO12_I2C0_SCL    = 2,
    OMW_GPIO13_I2C0_SDA    = 2,
    OMW_GPIO14_UART0_RX    = 2,
    OMW_GPIO15_UART0_TX    = 2,
    OMW_GPIO16_UART1_RX    = 2,
    OMW_GPIO17_UART1_TX    = 2,
    OMW_GPIO18_I2C0_SCL    = 2,
    OMW_GPIO19_I2C0_SDA    = 2,
    OMW_GPIO20_UART0_RX    = 2,
    OMW_GPIO21_UART0_TX    = 2,
    OMW_GPIO22_UART1_RX    = 2,
    OMW_GPIO23_UART1_TX    = 2,

    OMW_GPIO0_PIM0_NCS      = 3,
    OMW_GPIO1_SPIM0_SCK     = 3,
    OMW_GPIO2_SPIM0_MOSI    = 3,
    OMW_GPIO3_SPIM0_MISO    = 3,
    OMW_GPIO4_SPIM1_SCK     = 3,
    OMW_GPIO5_SPIM1_NCS     = 3,
    OMW_GPIO6_SPIM1_MOSI    = 3,
    OMW_GPIO7_SPIM1_MISO    = 3,
    OMW_GPIO8_SPIM0_NCS     = 3,
    OMW_GPIO9_SPIM0_SCK     = 3,
    OMW_GPIO10_SPIM0_MOSI   = 3,
    OMW_GPIO11_SPIM0_MISO   = 3,
    OMW_GPIO12_SPIM1_SCK    = 3,
    OMW_GPIO13_SPIM1_NCS    = 3,
    OMW_GPIO14_SPIM1_MOSI   = 3,
    OMW_GPIO15_SPIM1_MISO   = 3,
    OMW_GPIO16_SPIM0_NCS    = 3,
    OMW_GPIO17_SPIM0_SCK    = 3,
    OMW_GPIO18_SPIM0_MOSI   = 3,
    OMW_GPIO19_SPIM0_MISO   = 3,
    OMW_GPIO20_SPIM1_SCK    = 3,
    OMW_GPIO21_SPIM1_NCS    = 3,
    OMW_GPIO22_SPIM1_MOSI   = 3,
    OMW_GPIO23_SPIM1_MISO   = 3,

    OMW_GPIO0_UART0_CTS    = 4,
    OMW_GPIO1_UART0_RTS    = 4,
    OMW_GPIO2_UART1_CTS    = 4,
    OMW_GPIO3_UART1_RTS    = 4,
    OMW_GPIO4_SPIS0_NCS    = 4,
    OMW_GPIO5_SPIS0_SCK    = 4,
    OMW_GPIO6_SPIS0_MOSI   = 4,
    OMW_GPIO7_SPIS0_MISO   = 4,
    OMW_GPIO8_UART1_CTS    = 4,
    OMW_GPIO9_UART1_RTS    = 4,
    OMW_GPIO10_UART0_CTS   = 4,
    OMW_GPIO11_UART0_RTS   = 4,
    OMW_GPIO12_SPIS0_NCS   = 4,
    OMW_GPIO13_SPIS0_SCK   = 4,
    OMW_GPIO14_SPIS0_MOSI  = 4,
    OMW_GPIO15_SPIS0_MISO  = 4,
    OMW_GPIO16_I2C0_SCL    = 4,
    OMW_GPIO17_I2C0_SDA    = 4,
    OMW_GPIO18_UART1_CTS   = 4,
    OMW_GPIO19_UART1_RTS   = 4,
    OMW_GPIO20_SPIS0_NCS   = 4,
    OMW_GPIO21_SPIS0_SCK   = 4,
    OMW_GPIO22_SPIS0_MOSI  = 4,
    OMW_GPIO23_SPIS0_MISO  = 4,

    OMW_GPIO0_SPIS0_NCS    = 5,
    OMW_GPIO1_SPIS0_SCK    = 5,
    OMW_GPIO2_SPIS0_MOSI   = 5,
    OMW_GPIO3_SPIS0_MISO   = 5,
    OMW_GPIO4_UART0_RX     = 5,
    OMW_GPIO5_UART0_TX     = 5,
    OMW_GPIO6_UART1_RX     = 5,
    OMW_GPIO7_UART1_TX     = 5,
    OMW_GPIO8_SPIS0_NCS    = 5,
    OMW_GPIO9_SPIS0_SCK    = 5,
    OMW_GPIO10_SPIS0_MOSI  = 5,
    OMW_GPIO11_SPIS0_MISO  = 5,
    OMW_GPIO12_UART0_RX    = 5,
    OMW_GPIO13_UART0_TX    = 5,
    OMW_GPIO14_UART1_RX    = 5,
    OMW_GPIO15_UART1_TX    = 5,
    OMW_GPIO16_SPIS0_NCS   = 5,
    OMW_GPIO17_SPIS0_SCK   = 5,
    OMW_GPIO18_SPIS0_MOSI  = 5,
    OMW_GPIO19_SPIS0_MISO  = 5,
    OMW_GPIO20_I2C0_SCL    = 5,
    OMW_GPIO21_I2C0_SDA    = 5,
    OMW_GPIO22_QSPI_CLK    = 5,
    OMW_GPIO23_QSPI_NCS    = 5,

    OMW_GPIO0_QDEC_X_A    = 6,
    OMW_GPIO1_QDEC_X_B    = 6,
    OMW_GPIO2_QDEC_Y_A    = 6,
    OMW_GPIO3_QDEC_Y_B    = 6,
    OMW_GPIO4_QDEC_Z_A    = 6,
    OMW_GPIO5_QDEC_Z_B    = 6,
    OMW_GPIO6_QDEC_LED    = 6,
    OMW_GPIO7_CLK_32K     = 6,
    OMW_GPIO8_QDEC_X_A    = 6,
    OMW_GPIO9_QDEC_X_B    = 6,
    OMW_GPIO10_QDEC_Y_A   = 6,
    OMW_GPIO11_QDEC_Y_B   = 6,
    OMW_GPIO12_QDEC_Z_A   = 6,
    OMW_GPIO13_QDEC_Z_B   = 6,
    OMW_GPIO14_QDEC_LED   = 6,
    OMW_GPIO15_CLK_24M    = 6,
    OMW_GPIO16_QDEC_X_A   = 6,
    OMW_GPIO17_QDEC_X_B   = 6,
    OMW_GPIO18_QDEC_Y_A   = 6,
    OMW_GPIO19_QDEC_Y_B   = 6,
    OMW_GPIO20_QDEC_Z_A   = 6,
    OMW_GPIO21_QDEC_Z_B   = 6,
    OMW_GPIO22_QDEC_LED   = 6,
    OMW_GPIO23_CLK_48M    = 6,

    OMW_GPIO0_PWM_0    = 7,
    OMW_GPIO1_PWM_1    = 7,
    OMW_GPIO2_PWM_2    = 7,
    OMW_GPIO3_PWM_3    = 7,
    OMW_GPIO4_PWM_4    = 7,
    OMW_GPIO5_PWM_5    = 7,
    OMW_GPIO6_PWM_6    = 7,
    OMW_GPIO7_PWM_7    = 7,
    OMW_GPIO8_PWM_0    = 7,
    OMW_GPIO9_PWM_1    = 7,
    OMW_GPIO10_PWM_2   = 7,
    OMW_GPIO11_PWM_3   = 7,
    OMW_GPIO12_PWM_4   = 7,
    OMW_GPIO13_PWM_5   = 7,
    OMW_GPIO14_PWM_6   = 7,
    OMW_GPIO15_PWM_7   = 7,
    OMW_GPIO16_PWM_0   = 7,
    OMW_GPIO17_PWM_1   = 7,
    OMW_GPIO18_PWM_2   = 7,
    OMW_GPIO19_PWM_3   = 7,
    OMW_GPIO20_PWM_4   = 7,
    OMW_GPIO21_PWM_5   = 7,
    OMW_GPIO22_PWM_6   = 7,
    OMW_GPIO23_PWM_7   = 7,
}OMW_ENUM_GPIO_Func;

typedef enum {LOW = 0, HIGH = !LOW} lineStatus;
typedef enum {
          OMW_GPIO_IT_HIGH    = 0x30,
          OMW_GPIO_IT_LOW     = 0x40,
          OMW_GPIO_IT_RISING  = 0x50,
          OMW_GPIO_IT_FALLING = 0x60,
}OMW_GPIO_IT;

#define OMW_GPIO_CFG_BASE_ADDR GPIO_ATF_BASE
#define OMW_GPIO_CFG_VAL(s,f) ((s << 3) | f)

#endif
