#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "periph_gpio.h"
#include "periph_gpadc.h"
#include "periph_dma.h"

uint16_t srcdata = 20;
uint16_t dscdata;

int main()
{
    SDMA_TASK_InitTypeDef SDMA_InitStruct;
	
	SDMA_InitStruct.DMA_IT_EN = SDMA_TASK_INTR_DISABLE;             //dma_task中断使能
	SDMA_InitStruct.DMA_WORD_EN = SDMA_TASK_TRANSACTION_BYTE;    //数据传输格式
	SDMA_InitStruct.TASK_FORMAT = SDMA_TASK_MODE_NORMAL;         //数据传输模式
	SDMA_InitStruct.CMD_WAR = SDMA_TASK_CMD_WAR_DISABLE;         //cmd传输模式下 使能该位会将cmd命令地址原先数据取出，并与写入值计算后填入命令地址
	SDMA_InitStruct.CMD_PRE_EN = SDMA_TASK_CMD_PRE_DISABLE;      //cmd传输模式下 使能该位会在数据传输前进行cmd传输
	SDMA_InitStruct.TRIGGER_INDEX = 31;                     //下一个task触发序号，31为默认不触发
	SDMA_InitStruct.SRC_ADD_INC_EN = SDMA_TASK_SRC_ADD_INCRE_ENABLE;  //源数据地址自增使能
	SDMA_InitStruct.DST_ADD_INC_EN = SDMA_TASK_DST_ADD_INCRE_ENABLE;  //目标数据地址自增使能
	SDMA_InitStruct.SRC_BEGIN_UPD_EN = SDMA_TASK_SRC_BEGIN_UDT_DISABLE;  //源数据地址更新使能
	SDMA_InitStruct.DST_BEGIN_UPD_EN = SDMA_TASK_DST_BEGIN_UDT_DISABLE;  //目标数据地址更新使能
    SDMA_InitStruct.NUM_BYTES = 24;                        //传输数据长度
	SDMA_InitStruct.SRC_ADDR = (uint32_t)(&srcdata);                  //源数据地址
	SDMA_InitStruct.DST_ADDR = (uint32_t)(&dscdata);                  //目标数据地址
	SDMA_InitStruct.CMD_ADDR = 0;                           //cmd命令存入地址
	SDMA_InitStruct.CMD_WDATA = 0;                 //cmd命令存入数据
	SDMA_InitStruct.CMD_MASK = 0;                  //cmd命令存入
	SDMA_InitStruct.FIFO_SIZE = 0;                          //fifo模式传输轮询长度
	SDMA_InitStruct.FIFO_MODE_SRC = SDMA_TASK_FIFO_MODE_SRC_SPACE_DISABLE;                     //fifo模式源数据轮询使能
	SDMA_InitStruct.FIFO_MODE_DST = SDMA_TASK_FIFO_MODE_DST_SPACE_DISABLE;                     //fifo模式目标数据轮询使能

	//*(volatile uint8_t*)(0x40010204) = 0x20;		// 源数据输入
	
	DMA_Init();
	DMA_Cmd(ENABLE);
	DMA_Task_Init(&SDMA_InitStruct, (uint32_t*)SDMA_TaskTable[0]);
	DMA_value_set(SDMA_ALL, RESET);
	DMA_value_set(SDMA0, SET);
	DMA_action(SDMA_ACTION_ADD);
	while (DMA_status_bit(SDMA0));
	DMA_Cmd(DISABLE);
	
	printf("dscdata:%d\n", dscdata);
    
    while(1);
    return 0;
}

