#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "periph_gpio.h"
#include "periph_iic.h"

void gpio_init(void);
void iic_init(void);

int main()
{
	int  i = 0, e = 0;
    uint8_t send_buf[16], receive_buf[16];

    omw_dbg_init();
    iic_init();
    gpio_init();
    printf("IIC test ...\n");

    // page write test
    for(i=0;i<16;i++){
		send_buf[i] = i;
	}
	for(i=0;i<16;i++){
        IIC_SendByte(send_buf[i]);
	}
    IIC_MasterRecv(receive_buf,16);
    for(i=0;i<16;i++){
		if(receive_buf[i] != send_buf[i]){
			e++;
		}
	}
	printf("iic page write read test error times:%d",e);
}
void gpio_init(void){
   GPIO_InitTypeDef GPIO_InitStruct;
    // GPIO22_init
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_22;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPU;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO22_I2C0_SCL;
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
    GPIO_Init(&GPIO_InitStruct);
    //GPIO23_init
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = GPIO_PIN_23;
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_IPU;
    GPIO_InitStruct.GPIO_AltFunc = OMW_GPIO23_I2C0_SDA;
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
    GPIO_Init(&GPIO_InitStruct); 
}

void iic_init(void){
    IIC_InitTypeDef IIC_InitStruct;
    IIC_StructInit(&IIC_InitStruct);

    int salve_addr = 0x10;
	IIC_InitStruct.iic_mode = IIC_MODE_MASTER;                      
	IIC_InitStruct.iic_speed_mode = IIC_SPEED_MODE_SS;             //速度模式配置
	IIC_InitStruct.iic_target_addr_mode = IIC_TARGET_ADDR_MODE_7BIT;	//主机寻址模式配置，用作slave时不需要配置
	IIC_InitStruct.iic_target_addr = salve_addr ;                       //主机地址配置，用作slave时不需要配置 iic使能位置位时不可修改
	IIC_InitStruct.iic_slave_addr_mode = IIC_SLAVE_ADDR_MODE_7BIT;  	//从机寻址模式配置，用作master时不需要配置
	IIC_InitStruct.iic_slave_addr = 0;                                  //从机自身地址配置，用作master时不需要配置
	IIC_InitStruct.iic_rx_threshold = 0x07;                             //RX_FIFO水线配置
	IIC_InitStruct.iic_tx_threshold = 0x07;                             //TX_FIFo水线配置

    IIC_Cmd(DISABLE);
    IIC_Init(&IIC_InitStruct);
	IIC_Cmd(ENABLE);
}

