#include "omw_config.h"
#include "omw_dbg.h"
#include "omw_uart.h"
#include "periph_gpio.h"
#include "periph_gpadc.h"
#include "periph_timer.h"
#include "t1002_otp_cfg.h"


int main()
{
    TIMER_InitTypeDef TIMER_InitStruct;
    GPIO_InitTypeDef GPIO_InitStruct;

    // init
    omw_dbg_init();
    printf("TIMER test ...\n");
    
    //初始化GPIO
    GPIO_StructInit(&GPIO_InitStruct);
    GPIO_InitStruct.GPIO_Pin = (GPIO_PIN_2);
    GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUT_PP;
    GPIO_InitStruct.GPIO_DriveStrength = GPIO_DRIVE_STRENGTH_3; // highest drive strength
    GPIO_Init(&GPIO_InitStruct);



    TIMER_StructInit(&TIMER_InitStruct);
    //TIMER4每10ms通过轮询翻转一次GPIO2
    TIMER_InitStruct.TIMER_CLKSelect = TIMER_CLK_SEL_PLL48M;
    TIMER_InitStruct.TIMER_CLKDivide = TIMER_CLK_DIVIDE_128;
    TIMER_InitStruct.TIMER_PWMCmd = DISABLE;
    TIMER_InitStruct.TIMER_Mode = TIMER_MODE_USER_DEFINED;
    TIMER_InitStruct.TIMER_Loadcount = 3750;
    TIMER_Init(TIMER4, &TIMER_InitStruct);
    TIMER_ITCmd(TIMER4, DISABLE);
    TIMER_Cmd(TIMER4, ENABLE);
	
	while(1)
	{
		while(TIMER_GetFlagStatus(TIMER4) == RESET);
        if (GPIO_ReadOutputDataBit(GPIO_PIN_2))
        {
            GPIO_ResetBits(GPIO_PIN_2);
        }
        else
        {
            GPIO_SetBits(GPIO_PIN_2);
        }
		TIMER_ClearFlag(TIMER4);
	}


    while(1);
}





