
#ifndef __T1001_BT_TIMER_H__
#define __T1001_BT_TIMER_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "t1001.h"
#include "t1001_sleep.h"

#define BT_TIMER0                           ((uint16_t)0x0000)
#define BT_TIMER1                           ((uint16_t)0x0001)

typedef void (*BT_TIMER_CallbackType)(void *);

typedef struct BT_TIMER_HandleTypeS {
	struct BT_TIMER_HandleTypeS *next; /*!< Managed internally when the timer is started */
	uint32_t expiryTime; /*!< Managed internally when the timer is started */
	BT_TIMER_CallbackType callback; /*!< Pointer to the user callback */
	void *userData; /*!< Pointer to user data */
} BT_TIMER_HandleType;


void BT_TIMER_StopTimer(BT_TIMER_HandleType *timerHandle);
uint8_t BT_TIMER_CheckTimerStart(BT_TIMER_HandleType *timerHandle);
uint32_t BT_TIMER_GetCurrent(void);
uint32_t BT_TIMER_GetTimerTarget(void);
uint8_t BT_TIMER_TimerPast(uint32_t sysTime1, uint32_t sysTime2);
int32_t BT_TIMER_Diff(uint32_t sysTime1, uint32_t sysTime2);
int BT_TIMER_StartTimer(BT_TIMER_HandleType *timerHandle, uint32_t time);
int BT_TIMER_StartTimerRelative(BT_TIMER_HandleType *timerHandle, uint32_t relTimeout);
void BT_TIMER_Init(void);
void BT_TIMER_IRQHandler(void);

SleepModes BtTimer_SleepMode_Check(void);


#ifdef __cplusplus
}
#endif
#endif
