#ifndef __OMW_FLASH_H__
#define __OMW_FLASH_H__
#include <stdint.h>

#include "omw_config.h"

#define OMW_FLASH_SECTOR_SIZE OMW_FLASH_SS

#ifdef OMW_FLASH_HAS_PE
#define OMW_FLASH_PAGE_SIZE   OMW_FLASH_PS
#else
#define OMW_FLASH_PAGE_SIZE   OMW_FLASH_SECTOR_SIZE
#endif

#define OMW_FLASH_OVWT_CACHE_ADDR    (OMW_FLASE_BASE_ADDR + OMW_FLASE_TOTAL_SIZE - OMW_FLASH_TAIL_RS - OMW_FLASH_SECTOR_SIZE)

//when multi areas overwirte, all areas must in the same 4k bytes sector, and in diffrent 256 bytes area
struct omw_flash_ovwrt_tag
{
    uint32_t addr;
    void *   data;
    uint16_t len;
};

static inline void omw_flash_lock()
{
	__disable_irq();
}

static inline void omw_flash_unlock()
{
	__enable_irq();
}

void omw_flash_overwrite(struct omw_flash_ovwrt_tag * ovwrt_info, uint32_t ovwrt_info_sz, uint32_t sec_valid_max_offset);
void omw_flash_erase(uint32_t addr);
void omw_flash_read(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_write(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_get_uid( uint32_t * data);
void omw_flash_get_device_addr(uint8_t *dev_addr);
void omw_flash_sector_erase(uint32_t dst, uint16_t sec_nr);
/**
 * @brief 
 * 
 * @param addr 
 * @param buf 
 * @param len 
 * @param sec_valid_max_offset 用到了多大的区域1024/4096 
 */
static inline void omw_flash_overwrite_single(uint32_t addr, uint8_t * buf, uint32_t len, uint32_t sec_valid_max_offset)
{
    struct omw_flash_ovwrt_tag  ovwrt_i = {addr, buf, len};

    omw_flash_overwrite(&ovwrt_i, 1, sec_valid_max_offset);
}

#ifdef OMW_FLASH_HAS_PE
void omw_flash_erase_base_pe_256bytes(char *dst, int length
                            #ifdef OMW_FLASH_HAS_PE
                            , uint8_t pe_flag
                            #endif
                            );

void omw_flash_overwrite_pe_256bytes(uint32_t addr, uint8_t * buf, uint32_t len);
void omw_flash_erase_pe_256bytes(uint32_t addr);
void omw_flash_sector_erase_pe_256bytes(uint32_t addr);
#define omw_flash_page_erase_pe_256bytes(a)  omw_flash_erase_pe_256bytes(a)
#endif

#endif
