#include "omw_gpio.h"
#include "omw_timer.h"
#include "Inital.h"

#define NVIC_EnableIRQ(IRQn) csi_vic_enable_irq(IRQn)
#define NVIC_SetPriority(IRQn, priority) csi_vic_set_prio(IRQn, priority)

uint8_t Key_num[4] = {0};

void hc_gpio_init(void)
{
	omw_gpio_init(OMW_GPIO_PIN2,OMW_GPIO_MODE_IN_PULL_UP,OMW_GPIO_DRIVE_STRENTH0);	//GPIO2上拉输入
	omw_gpio_init(OMW_GPIO_PIN19,OMW_GPIO_MODE_IN_FLOATING,OMW_GPIO_DRIVE_STRENTH3);//GPIO19推挽输出：状态floating，output使能，输出高	
	omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
	omw_gpio_set_output(OMW_GPIO_PIN19,HIGH);
}

void hc_irq_init(void)
{
	NVIC_SetPriority(TIMER0_IRQn,IRQ_CRITICAL_PRIORITY);
	NVIC_EnableIRQ(TIMER0_IRQn);								//总中断开启  
}

void hc_Timer_init(void)
{
	num_timer1 = 0;
	num_timer2 = 0;
	
	hc_irq_init();
		
	TIMER_InitTypeDef timer_struct_0;
	omw_timer_struct_init(&timer_struct_0);
	timer_struct_0.timer_mode = OMW_TIMER_MODE_USER_DEFINED;	//自由定义count数值，free_mode模式下，计数器数值最大为65535
	timer_struct_0.timer_clk_divide = OMW_TIMER_CLK_DIVIDE_2;	//时钟分频，默认二分频
	timer_struct_0.timer_clk = OMW_TIMER_CLK_SEL_XTAL24M;		//时钟选择
	timer_struct_0.timer_loadcount = 6000;						//定义count数值，当前设定下以12M时钟计数自减,0.5ms进入中断一次
	timer_struct_0.timer_pwm_en = OMW_TIMER_PWM_DISABLE;		//PWM使能位
	omw_timer_en(TIMER0,DISABLE);
	omw_timer_init(TIMER0,&timer_struct_0);
	omw_timer_it_en(TIMER0,ENABLE);
	omw_timer_en(TIMER0,ENABLE);
}

void KEY_statusswitch(void)
{
	if(Key_status)
	{
		Key_status = 0;
		
		Key_num[0] = omw_gpio_read_input_data(OMW_GPIO_PIN2);
		if(Key_num[0]==0)
			{
				Key_1++;
				if(Key_1>=4)
				{TX_FLG = 1;Key_1 = 0;}
			}	
		else 
			{Key_1 = 0;}
	/*	Key_num[1] = omw_gpio_read_input_data(OMW_GPIO_PIN19);
		if(Key_num[1]==0)
			{
				Key_2++;
				if(Key_2>=4)
				{TX_FLG = 1;Key_2 = 0;}
			}	
		else 
			{Key_2=0;}
		Key_num[2] = omw_gpio_read_input_data(OMW_GPIO_PIN20);
		if(Key_num[2]==0)
			{
				Key_3++;
				if(Key_3>=4)
				{TX_FLG = 1;Key_3 = 0;}
			}	
		else 
			{Key_3=0;}
		Key_num[3] = omw_gpio_read_input_data(OMW_GPIO_PIN21);
		if(Key_num[3]==0)
			{
				Key_4++;
				if(Key_4>=4)
				{TX_FLG = 1;Key_4 = 0;}
			}	
		else 
			{Key_4=0;}*/
	}
}

void KEY_off_status(void)
{
	Key_num[0] = omw_gpio_read_input_data(OMW_GPIO_PIN2);
//	Key_num[1] = omw_gpio_read_input_data(OMW_GPIO_PIN19);
//	Key_num[2] = omw_gpio_read_input_data(OMW_GPIO_PIN20);
//	Key_num[3] = omw_gpio_read_input_data(OMW_GPIO_PIN21);
	
//	if((Key_num[0]!=0)&&(Key_num[1]!=0)&&(Key_num[2]!=0)&&(Key_num[3]!=0))
	if(Key_num[0]!=0)
	{
		Key_success_FLG = 1;
	}
	else {
		Key_success_FLG = 0;
	}
}