#ifndef DATA_QUEUE_H
#define DATA_QUEUE_H

#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include "omw_config.h"
#define MAX_SIZE 4      // 队列的最大容量
#define MAX_DATA_LEN 74 // 每个元素数据的最大长度

// 队列元素结构体
typedef struct {
    int type;                   // 数据类型
    uint8_t data[MAX_DATA_LEN]; // 数据内容
    int length;                 // 数据长度
} queue_element_t;

// 队列结构体
typedef struct {
    queue_element_t elements[MAX_SIZE]; // 用于存储队列元素的数组
    int front;                          // 队头指针
    int rear;                           // 队尾指针
    int size;                           // 队列当前大小
} queue_t;

bool en_queue(queue_t *q, int type, uint8_t *data, int length);
bool de_queue(queue_t *q, queue_element_t *element);
bool is_empty(queue_t *q);
void init_queue(queue_t *q);
#endif
