#ifndef PORT_PROCESS_H
#define PORT_PROCESS_H

#include <stdbool.h>
#include <stdint.h>
#include "port.h"



#define HAL_FLASH_BANK_SIZE 0x2000
#define HAL_FLASH_BANK_0_ADDR 0x10020000
#define HAL_FLASH_BANK_1_ADDR 0x10021000




void custom_process_data_from_ctrlr(uint8_t h_tp, uint8_t *data, uint8_t len);
void platform_memory_init(void);
void platform_run_loop_init(void);
void platform_transport_get_instance_init(void);
void platform_flash_bank_init(void);
void platform_packet_handler(void);
void platform_init_complete(bool state);
void set_ble_addr(uint8_t addr[6]);
void reset_controller(void);
void clean_rx_data_from_control(void);
#endif



