#ifndef _HCI_DRIVER_H_
#define _HCI_DRIVER_H_

#include "utils/simple_buf.h"
#include "controller/ll.h"

#include "t1001_sleep.h"

#ifdef __cplusplus
extern "C" {
#endif


void hci_driver_node_rx_enqueue(void* node_rx);
void* hci_driver_node_rx_get(void);
void* hci_driver_node_rx_dequeue(void);
void hci_driver_polling_work(void);
int hci_driver_send(simple_buf_t *buf);

void hci_driver_send_to_upstack(simple_buf_t *buf);

typedef void (*bt_hci_controller_send_cb_t)(simple_buf_t *buf);
int hci_driver_open(void* cb);
int hci_driver_open_patch(void* cb);

SleepModes Bt_Controller_SleepMode_Check(void);

#ifdef __cplusplus
}
#endif


#endif