#include "omw_uart.h"
#include "t1001_it.h"
#include "omw_gpio.h"
#include "omw_timer.h"

// #define GPADC_Handler   Interrupt7_Handler
#if defined(OMW_HAS_SCH) && (defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0))
#include "omw_rtos.h"
#endif
//############################################################
//############################################################
//############################################################
//################################ 添加 ######################
//############################################################
//############################################################
//############################################################

uint32_t tick_ms=0;

extern void calc_hp_offset_at_curr_temp();
extern void RF_BT_IRQHandler(void);
#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
extern void BT_TIMER_IRQHandler(void);
#endif
extern void VTIMER_IRQHandler(void);
#ifdef OMW_EN_DEEP_SLEEP
extern void Check_PwrOn_OnBbDmaIrq();
extern void  Check_PwrOn_OnBbDmaIrq_Before();
#endif

#ifndef OMW_MCU_ONLY
void  dynamic_agc_info_get();
#endif
ATTRIBUTE_ISR __RAM_CODE_SECTION void RADIO_DMA_Handler(void)
{
    #ifndef OMW_MCU_ONLY
    //dynamic_agc_info_get();
    #endif

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq_Before();
    #endif

    omw_hw_set_in_irq_flag();

    RF_BT_IRQHandler();

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq();
    #endif

    #if defined(OMW_HAS_SCH) && (defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0))
    omw_rtos_low_pri_free_cpu(OMW_CTRL_ARG_FLAG);
    #endif

    omw_hw_clr_in_irq_flag();
}

#if defined(OMW_BLE_V0) || defined(OMW_BLE_V0_2_0)
ATTRIBUTE_ISR __RAM_CODE_SECTION void RADIO_TICK_Handler(void)
{
    BT_TIMER_IRQHandler(); //rom api

    #ifdef OMW_EN_DEEP_SLEEP
    Check_PwrOn_OnBbDmaIrq();
    #endif

    #if defined(OMW_HAS_SCH)
    omw_rtos_low_pri_free_cpu(OMW_CTRL_ARG_FLAG);
    #endif

    #ifdef OMW_BLE_V0
    calc_hp_offset_at_curr_temp();
    #endif
}
#endif




#if defined(OMW_BLE_HOST_V0) || defined(OMW_BLE_HOST_V1) || defined(OMW_BLE_HOST_V2) || defined(OMW_BLE_HOST_OTHER) || defined(OMW_CLTR_SLEEP_TEST)
ATTRIBUTE_ISR void RTC_Handler(void)
{
    omw_hw_set_in_irq_flag();

    VTIMER_IRQHandler();
	
	
    omw_hw_clr_in_irq_flag();
}
#endif



ATTRIBUTE_ISR void TIMER0_Handler(void)
{
//	static uint8_t flag=0; 
//	flag=!flag;
//	omw_gpio_set_output(OMW_GPIO_PIN19, flag);
	omw_timer_it_clr();
	tick_ms++;
}

#if 0
ATTRIBUTE_ISR void GPADC_Handler(void)
{

}

ATTRIBUTE_ISR void WDT_Handler(void)
{

}

ATTRIBUTE_ISR void GPIO_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER0_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER1_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER2_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER3_Handler(void)
{

}



ATTRIBUTE_ISR void TIMER5_Handler(void)
{
  omw_gpio_set_output_en(OMW_GPIO_PIN19,ENABLE);
  omw_gpio_set_output(OMW_GPIO_PIN19, HIGH);
}

ATTRIBUTE_ISR void TIMER6_Handler(void)
{

}

ATTRIBUTE_ISR void TIMER7_Handler(void)
{

}
#endif
