#include "t1001_uart.h"

uint8_t  uart_irq_id[OMW_MAX_UART_NUM] = {UART0_IRQn, UART1_IRQn};

uint32_t omw_get_uart_clk()
{
    if( SYS_CTRL->SYS_CLKSEL_b.REG_UART_CLK_SEL == 2)
    {
        return (XTAL_FREQ) * 2000000;
    }
    else
    {
        return (XTAL_FREQ) * 1000000;
    }
}

void omw_enable_uart_rx_it(uint32_t *uart_base_addr)
{
    uint32_t idx = OMW_GET_UART_IDX(uart_base_addr);
    uint32_t irq_n  = uart_irq_id[idx];

    omw_set_irq_prio(irq_n, IRQ_HIGH_PRIORITY);
    omw_enable_irq(irq_n);
}


