#ifndef __T1001_UART_H__
#define __T1001_UART_H__

#include "t1001.h"

#define  OMW_UART0_BASE       UART_BASE
#define  OMW_UART1_BASE       0x41002000

#define  OMW_UART0            ((uint32_t*) OMW_UART0_BASE)
#define  OMW_UART1            ((uint32_t*) OMW_UART1_BASE)

/* UART registers addr definition */
#define  OMW_UART_RBR       0x00    /* Receive Buffer Register (32 bits, R) */
#define  OMW_UART_THR       0x00    /* Transmit Holding Register (32 bits, W) */
#define  OMW_UART_DLL       0x00    /* Divisor Latch(Low)  (32 bits, R/W) */
#define  OMW_UART_IER       0x01    /* Interrupt Enable Register (32 bits, R/W) */
#define  OMW_UART_DLH       0x01    /* Divisor Latch(High) (32 bits, R/W) */
#define  OMW_UART_IIR       0x02    /* Interrupt Identity Register (32 bits, R) */
#define  OMW_UART_FCR       0x02    /* fifo Countrol Register (32 bits, W) */
#define  OMW_UART_LCR       0x03    /* Line Control Register (32 bits, R/W) */
#define  OMW_UART_MCR       0x04    /* Modem Control Register (32 bits, W) */
#define  OMW_UART_LSR       0x05    /* Line Status Register (32 bits, R) */
#define  OMW_UART_MSR       0x06    /* Modem Status Register (32 bits, R/W) */
#define  OMW_UART_USR       0x1f    /* UART Status Register (32 bits, R/W) */
#define  OMW_UART_DLF       0x30    /* UART Divisor Latch(Float)(4 bits, R/W) */
#define  OMW_UART_LCR_EXT   0x33    /* UART Divisor Latch(Float)(4 bits, R/W) */

#define  OMW_UART_BUSY_TIMEOUT      1000000
#define  OMW_UART_RECEIVE_TIMEOUT   1000
#define  OMW_UART_TRANSMIT_TIMEOUT  1000

/* UART register bit definitions */
#define  OMW_USR_UART_BUSY           0x01
#define  OMW_LSR_DATA_READY          0x01
#define  OMW_LSR_THR_EMPTY           0x20
#define  OMW_IER_RDA_INT_ENABLE      0x01
#define  OMW_IER_THRE_INT_ENABLE     0x02
#define  OMW_IIR_NO_ISQ_PEND         0x01

#define  OMW_LCR_SET_DLAB            0x80       /* enable r/w DLR to set the baud rate */
#define  OMW_LCR_PARITY_ENABLE       0x08       /* parity enabled */
#define  OMW_LCR_PARITY_EVEN         0x10   /* Even parity enabled */
#define  OMW_LCR_PARITY_ODD          0xef   /* Odd parity enabled */
#define  OMW_LCR_WORD_SIZE_5         0xfc   /* the data length is 5 bits */
#define  OMW_LCR_WORD_SIZE_6         0x01   /* the data length is 6 bits */
#define  OMW_LCR_WORD_SIZE_7         0x02   /* the data length is 7 bits */
#define  OMW_LCR_WORD_SIZE_8         0x03   /* the data length is 8 bits */
#define  OMW_LCR_STOP_BIT1           0xfb   /* 1 stop bit */
#define  OMW_LCR_STOP_BIT2           0x04  /* 1.5 stop bit */

#define  OMW_LSR_PFE              0x80
#define  OMW_LSR_TEMT             0x40
#define  OMW_LSR_THRE             0x40
#define  OMW_LSR_BI               0x10
#define  OMW_LSR_FE               0x08
#define  OMW_LSR_PE               0x04
#define  OMW_LSR_OE               0x02
#define  OMW_LSR_DR               0x01
#define  OMW_LSR_TRANS_EMPTY      0x20

#define OMW_MAX_UART_NUM    2

#define OMW_GET_UART_IDX(base_addr)    ({uint32_t  _idx = 0; if (uart_base_addr == OMW_UART1) {_idx = 1;} _idx;})

uint32_t omw_get_uart_clk();
void omw_enable_uart_rx_it(uint32_t *uart_base_addr);

#endif
