#ifndef __HM1002_TIMERPLUS_H__
#define __HM1002_TIMERPLUS_H__

#include "BL210x.h"

typedef enum
{
	HALL_0  = 0x01,
	HALL_1  = 0x02,
	HALL_2  = 0x04,
} TIMPLUS_HallTypeDef;

typedef enum
{
	TIMPLUS_LOW  = 0x01,
	TIMPLUS_HIGH = 0x02,
} TIMPLUS_TypeTypeDef;

typedef enum
{
	TIMER_MODE = 0x00,
	COUNT_MODE = 0x01,
	INCAP_MODE = 0x02,
	HALL_MODE  = 0x03,
} TIMPLUS_ModeTypeDef;

typedef enum
{
	SYSCLK_DIV = 0x00,
	CNTSRC0    = 0x01,
	CNTSRC1    = 0x02,
} TIMPLUS_ClkSelTypeDef;


typedef enum
{
	TIMPLUS_IN0 = 0x00,
	TIMPLUS_IN1 = 0x01,
} TIMPLUS_ExtSelTypeDef;

typedef enum
{
	EXTLEVEL_RISE = 0x00,
	EXTLEVEL_FALL = 0x01,
	EXTLEVEL_BOTH = 0x02,
} TIMPLUS_ExtLevelTypeDef;


typedef struct
{
	uint8_t                 ClkDiv;       //ʱӷƵ
	
	TIMPLUS_ModeTypeDef     Mode;         //ģʽ
	
	TIMPLUS_ClkSelTypeDef   ClkSel;       //ʱԴѡ  
	
	TIMPLUS_ExtSelTypeDef   ExtSel;       //ģʽ벶ģʽźѡ
	
	TIMPLUS_ExtLevelTypeDef ExtLevel;     //ģʽ벶ģʽźЧѡ
	
	FunctionalState         OutEn;        //ʹ 
	
	uint16_t                Period;       //ֵ	
	
	FunctionalState         Ovf_IE;       //жʹ
	
	FunctionalState         RIse_IE;      //жʹ
	
	FunctionalState         Fall_IE;      //½жʹ
	
} TIMPLUS_CommonInitTypeDef;


typedef struct
{
	FunctionalState         Hall0_Rise_IE;     //HALL0жʹ
	
	FunctionalState         Hall0_Fall_IE;     //HALL0½жʹ
	
	FunctionalState         Hall1_Rise_IE;     //HALL1жʹ
	
	FunctionalState         Hall1_Fall_IE;     //HALL1½жʹ
	
	FunctionalState         Hall2_Rise_IE;     //HALL2жʹ
	
	FunctionalState         Hall2_Fall_IE;     //HALL2½жʹ	
} TIMPLUS_HallInitTypeDef;


void TIMPLUS_Common_Init(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_CommonInitTypeDef * TIMPLUS_CommonInitStruct);
void TIMPLUS_Hall_Init(TIMPLUS_TypeDef * TIMPLUSx, TIMPLUS_HallInitTypeDef * TIMPLUS_HallInitStruct);
void TIMPLUS_Start(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_Stop(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_SetClkDiv(TIMPLUS_TypeDef * TIMPLUSx,uint8_t Clk_Div);
void TIMPLUS_SetMode(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ModeTypeDef Mode);
void TIMPLUS_SetClkSel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ClkSelTypeDef ClkSel);
void TIMPLUS_SetExtSel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ExtSelTypeDef ExtSel);
void TIMPLUS_SetExtLevel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,TIMPLUS_ExtLevelTypeDef ExtLevel);
void TIMPLUS_SetOutEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,FunctionalState OutEn);
void TIMPLUS_SetPeriod(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type,uint16_t Period);
uint16_t TIMPLUS_GetPeriod(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint16_t TIMPLUS_GetCurrentValue(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint16_t TIMPLUS_GetCaptureValue(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint8_t TIMPLUS_GetHallLevel(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
void TIMPLUS_IntOvfEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntOvfDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint8_t TIMPLUS_IntOvfState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntOvfClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntRiseEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntRiseDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint8_t TIMPLUS_IntRiseState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntRiseClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntFallEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntFallDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
uint8_t TIMPLUS_IntFallState(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntFallClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_TypeTypeDef type);
void TIMPLUS_IntHallRiseEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
void TIMPLUS_IntHallRiseDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
uint8_t TIMPLUS_IntHallRiseState(TIMPLUS_TypeDef * TIMPLUSx);
void TIMPLUS_IntHallRiseClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
void TIMPLUS_IntHallFallEn(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
void TIMPLUS_IntHallFallDis(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);
uint8_t TIMPLUS_IntHallFallState(TIMPLUS_TypeDef * TIMPLUSx);
void TIMPLUS_IntHallFallClr(TIMPLUS_TypeDef * TIMPLUSx,TIMPLUS_HallTypeDef HallLevel);

                   
#endif //__HM1002_TIMERPLUS_H__
