/***********************************************************************
 * Copyright (c)  2017 - 2020, Unicmicro Co.,Ltd .
 * All rights reserved.
 * Filename    : app.h
 * Description : app header file
 * Author(s)   : wanyi
 * version     : V1.0
 * Modify date : 2020-07-16
 ***********************************************************************/
#ifndef __APP_H__
#define __APP_H__

#include "common.h"

//  For system power
void lowpower_test(void);
void active_test(void);

//  for uart
void uart0_rec_pro(void);

void uart0_send_pro(void);

void uart_init(void);

//  for ADC
void adc_test(void);

void adc_single_mode_test(void);

void adc_continous_mode_test(void);

void adc_single_mode_func(void);

void adc_continous_mode_func(void);

//  for beeper
void beeper_test(void);

//  for eflash
#define DATA_SIZE   20

void uart0_rec_pro(void);

void uart0_send_pro(void);

void uart_init(void);

void eflash_test(void);

void eflash_page_check_8bits(uint16_t base_addr,uint8_t w_val, uint8_t page);
void eflash_page_check_bytes(uint16_t base_addr,uint8_t w_val, uint32_t length);
void eflash_page_check_byte(uint16_t base_addr, uint8_t start_page, uint8_t num_page);

//  for GPIO
void gpio_test(void);
void gpio_int_pro(void);
void gpio_in_test(void);
void gpio_out_test(void);
void gpio_irq_test(void);

//  for I2C
#define I2C_SLAVE_ADDR   0x20

void i2c_test(void);
void i2c_master_test(void);
void i2c_master_send_test(void);
void i2c_master_recv_test(void);
void i2c_slave_test(void);
void i2c_slave_write_test(void);
void i2c_slave_read_test(void);

//  for timer
void timer_test(void);
void lptim_timer_test(void);
void lptim_pwm_test(void);	

//  for PWM
void pwm0_test(void);
void pwm1_test(void);
void pwm2_test(void);

//  for SPI
void spi_test(void);
#endif

