#include "BL210x_iic.h"
//#include "delay.h"


/****************************************************************************************************************************************** 
* :	IIC_Init()
* ˵:	IICʼ
*     : uint16_t clk		IICʱ
*			uint8_t IE_Enable	жʹ
*     : 
* ע: ģֻܹģʽ
******************************************************************************************************************************************/
void IIC_Init(IIC_TypeDef *IICx,uint16_t clk,uint8_t IE_Enable)
{
//	assert_param(IS_IIC_CLK(clk));                   //ĲclkǷϷ    
//	
//	assert_param(IS_IIC_INT(IE_Enable));             //ĲIE_EnableǷϷ    
	
	switch((uint32_t)IICx)
	{
		case ((uint32_t)IIC0):
			
			SYS->CLKEN |= 0x01 << SYS_CLKEN_IIC0_POS;    //IIC0ʱ
		
			break;
	}
	
	IIC_Close(IICx);                                     //رIIC
	
	IICx->CLKDIV = SystemCoreClock/5000/clk - 1;         //IICʱ
	
	IICx->CTRL &= ~(0x01 << IIC_CTRL_IE_POS);
	IICx->CTRL |= (IE_Enable << IIC_CTRL_IE_POS);        //ж
	
	if(IE_Enable)
	{
		switch((uint32_t)IICx)
		{
			case ((uint32_t)IIC0):
				
				NVIC_EnableIRQ(IIC0_IRQn);               //ʹж
			
				break;
		}
	}
}


/****************************************************************************************************************************************** 
* :	IIC_Open()
* ˵:	IIC򿪣շ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Open(IIC_TypeDef *IICx)
{
	IICx->CTRL |= (0x01 << IIC_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* :	IIC_Close()
* ˵:	IICرգֹշ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Close(IIC_TypeDef *IICx)
{
	IICx->CTRL &= ~(0x01 << IIC_CTRL_EN_POS);
}


/****************************************************************************************************************************************** 
* :	IIC_Start()
* ˵:	ʼźŲ豸ַ
*     : uint8_t addr			豸ַ			
*     : uint8_t					1 յACK   0 յNACK
* ע: 
******************************************************************************************************************************************/
uint8_t IIC_Start(IIC_TypeDef *IICx,uint8_t addr)
{
	IICx->TXR = addr;       //ӻַ
	IICx->CR = (0x01 << IIC_CR_START_POS) | (0x01 << IIC_CR_WR_POS);   //ʼλʹӻַ
	
	while(IICx->SR & IIC_SR_TIP_MSK) __NOP();		//ȴ
	return (IICx->SR & IIC_SR_RACK_MSK) ? 0 : 1;     //ؽյӦź
}


/****************************************************************************************************************************************** 
* :	IIC_Stop()
* ˵:	ֹͣź
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Stop(IIC_TypeDef *IICx)
{
	IICx->CR = (0x01 << IIC_CR_STOP_POS);            //ֹͣź
	while(IICx->SR & IIC_SR_BUSY_MSK) __NOP();		//æ
}


/****************************************************************************************************************************************** 
* :	IIC_Write()
* ˵:	дһ
*     : uint8_t data			Ҫд			
*     : uint8_t					1 յACK   0 յNACK
* ע: 
******************************************************************************************************************************************/
uint8_t IIC_Write(IIC_TypeDef *IICx,uint8_t data)
{	
	IICx->TXR = data;                                //д
	IICx->CR = (0x01 << IIC_CR_WR_POS);              //д
	while(IICx->SR & IIC_SR_TIP_MSK) __NOP();		//ȴ
	return (IICx->SR & IIC_SR_RACK_MSK) ? 0 : 1;     //ؽյӦź
}


/****************************************************************************************************************************************** 
* :	IIC_Read()
* ˵:	ȡһ
*     : uint8_t ack				1 ACK   0 NACK			
*     : uint8_t					ȡ
* ע: 
******************************************************************************************************************************************/
uint8_t IIC_Read(IIC_TypeDef *IICx,uint8_t ack)
{
	IICx->CR = (0x01 << IIC_CR_RD_POS) | ((ack ? 0 : 1) << IIC_CR_ACK_POS);              //ͷӦź
	while(IICx->SR & IIC_SR_TIP_MSK) __NOP();		                                    //ȴ 
	return IICx->RXR;                            //ضȡ            
}


/******************************************************************************************************************************************

¼ǿIICжϺõĺ

*******************************************************************************************************************************************/

/****************************************************************************************************************************************** 
* :	IIC_Start_NoWait()
* ˵:	ʼźŲ豸ַ
*     : uint8_t addr	  豸ַ			
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Start_NoWait(IIC_TypeDef *IICx,uint8_t addr)
{
	IICx->TXR = addr;       //ӻַ
	IICx->CR = (0x01 << IIC_CR_START_POS) | (0x01 << IIC_CR_WR_POS);   //ʼλʹӻַ
}


/****************************************************************************************************************************************** 
* :	IIC_Write_NoWait()
* ˵:	дһ
*     : uint8_t data			Ҫд			
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Write_NoWait(IIC_TypeDef *IICx,uint8_t data)
{	
	IICx->TXR = data;                                //д
	IICx->CR = (0x01 << IIC_CR_WR_POS);              //д
}


/****************************************************************************************************************************************** 
* :	IIC_Read_NoWait()
* ˵:	ȡһ
*     : uint8_t ack				1 ACK   0 NACK			
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_Read_NoWait(IIC_TypeDef *IICx,uint8_t ack)
{
	IICx->CR = (0x01 << IIC_CR_RD_POS) | ((ack ? 0 : 1) << IIC_CR_ACK_POS);              //ͷӦź         
}


/****************************************************************************************************************************************** 
* :	IIC_Wait_ACK()
* ˵:	ȡӦź
*     : 		
*     :  0  NACK   1  ACK
* ע: 
******************************************************************************************************************************************/
uint8_t IIC_Wait_ACK(IIC_TypeDef *IICx)
{
	if(IICx->SR & IIC_SR_RACK_MSK)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

/****************************************************************************************************************************************** 
* :	IIC_IntEn()
* ˵: IICжʹ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_IntEn(IIC_TypeDef *IICx)
{	
	IICx->CTRL |= (0x01 << IIC_CTRL_IE_POS);
}


/****************************************************************************************************************************************** 
* :	IIC_IntDis()
* ˵: IICжϽ
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_IntDis(IIC_TypeDef *IICx)
{	
	IICx->CTRL &= ~(0x01 << IIC_CTRL_IE_POS);
}


/****************************************************************************************************************************************** 
* :	IIC_IntClr()
* ˵: IICж
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
void IIC_IntClr(IIC_TypeDef *IICx)
{	
	IICx->CR = (0x01 << IIC_CR_IF_POS);
}


/****************************************************************************************************************************************** 
* :	IIC_IntStat()
* ˵: IICж״̬
*     : 
*     : 
* ע: 
******************************************************************************************************************************************/
uint8_t IIC_IntStat(IIC_TypeDef *IICx)
{	
	return (IICx->SR & IIC_SR_IF_MSK) ? 1 : 0;		
}


