#include "BL210x_port.h"


/****************************************************************************************************************************************** 
* : PORT_Init()
* ˵:	˿Źѡ
*     : PORT_InitTypeDef* PORT_InitStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void PORT_Init(PORT_InitTypeDef* PORT_InitStruct)
{
	uint32_t temp = 0;
	
//	assert_param(IS_PORT_ALL(PORT_InitStruct->Port));                             //ĲPortǷϷ   
//	
//	assert_param(IS_INPUT_EN(PORT_InitStruct->Input_En));                         //ĲInput_EnǷϷ   
//	
//	assert_param(IS_PORT_FUNC(PORT_InitStruct->Func));                            //ĲFuncǷϷ 
	
	switch(PORT_InitStruct->Port)
	{
		case PORTA:
			
#ifdef IC_BL2101
  		PORT->PORTA_SEL &= ~(0x03 << ((PORT_InitStruct->Pin)*2));                           
			PORT->PORTA_SEL |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*2));          //PORTA IO˿ڹ
#endif
		
#ifdef IC_BL2102
			if(PORT_InitStruct->Pin <= GPIO_PIN7)
			{
				temp = PORT->PORTA_SEL0;
				
				temp &= ~(0x0F << ((PORT_InitStruct->Pin)*4)); 
				temp |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*4));
				
				PORT->PORTA_SEL0 = temp;                                          //PORTA0-7 IO˿ڹ
			}
			else if(PORT_InitStruct->Pin <= GPIO_PIN15)
			{
				temp = PORT->PORTA_SEL1;
				
				temp &= ~(0x0F << ((PORT_InitStruct->Pin - GPIO_PIN8)*4)); 
				temp |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin - GPIO_PIN8)*4));

				PORT->PORTA_SEL1 = temp;                                          //PORTA8-15 IO˿ڹ
			}
#endif		
			
			if(PORT_InitStruct->Input_En == ENABLE)                                 
			{
				PORT->PORTA_INEN |=  (1 << (PORT_InitStruct->Pin));            //ʹܴ
			}
			else
			{
				PORT->PORTA_INEN &=  ~(1 << (PORT_InitStruct->Pin));           //ʹܹر
			}
		break;

#ifdef IC_BL2101			
		case PORTB:
			
			PORT->PORTB_SEL &= ~(0x03 << ((PORT_InitStruct->Pin)*2));
			PORT->PORTB_SEL |= ((PORT_InitStruct->Func) << ((PORT_InitStruct->Pin)*2));        //PORTB IO˿ڹ
			
			if(PORT_InitStruct->Input_En)
			{
				PORT->PORTB_INEN |=  (1 << (PORT_InitStruct->Pin));            //ʹܴ
			}
			else
			{
				PORT->PORTB_INEN &=  ~(1 << (PORT_InitStruct->Pin));           //ʹܹر
			}
		break;
#endif
			
		default:
		break;
	}
}

/****************************************************************************************************************************************** 
* : PORT_CFG_Init()
* ˵:	˿
*     : PORT_CFGTypeDef* PORT_CFGStruct
*     : 
* ע: 
******************************************************************************************************************************************/
void PORT_CFG_Init(PORT_CFGTypeDef* PORT_CFGStruct)
{
	uint32_t temp = 0;
	
#ifdef IC_BL2101
	PORT->PORT_CFG &= ~(3 << PORT_CFG_A0_7_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_A0_7) << PORT_CFG_A0_7_DS_POS);           //PORTA0-A7
		
	PORT->PORT_CFG &= ~(3 << PORT_CFG_A8_15_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_A8_15) << PORT_CFG_A8_15_DS_POS);         //PORTA8-A15

	PORT->PORT_CFG &= ~(3 << PORT_CFG_B0_7_DS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->Out_Cur_B0_7) << PORT_CFG_B0_7_DS_POS);           //PORTB0-B7
		
	PORT->PORT_CFG &= ~(3 << PORT_CFG_PUR_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->PullUp_Res) << PORT_CFG_PUR_POS);                 //ö˿PORTA PORTB
	
	PORT->PORT_CFG &= ~(1 << PORT_CFG_HYS_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->InputHys) << PORT_CFG_HYS_POS);                   //PORTA PORTB͵ȼ
	
	PORT->PORT_CFG &= ~(1 << PORT_CFG_WKRF_POS);
	PORT->PORT_CFG |=  ((PORT_CFGStruct->WakeUp_Edge) << PORT_CFG_WKRF_POS);	             //PORTA PORTBĻѹ
#endif

	temp = PORT->PORT_CFG;
	
	temp &= ~(0x03 << PORT_CFG_DS_POS);
	temp |=  ((PORT_CFGStruct->Out_Cur) << PORT_CFG_DS_POS);                     //PORTA
	
	temp &= ~(0x03 << PORT_CFG_PUR_POS);
	temp |=  ((PORT_CFGStruct->PullUp_Res) << PORT_CFG_PUR_POS);                 //ö˿PORTA
	
	temp &= ~(0x01 << PORT_CFG_HYS_POS);
	temp |=  ((PORT_CFGStruct->InputHys) << PORT_CFG_HYS_POS);                   //PORTA͵ȼ
	
	temp &= ~(0x01 << PORT_CFG_WKRF_POS);
	temp |=  ((PORT_CFGStruct->WakeUp_Edge) << PORT_CFG_WKRF_POS);	             //PORTAĻѹ
	
	PORT->PORT_CFG = temp;	
}



