#ifndef __BL210x_PORT_H__
#define __BL210x_PORT_H__

#include "BL210x.h"

typedef struct
{
	uint8_t Port;         //˿       
    uint8_t Pin;          //ź                              
    uint8_t Func;         //
	uint8_t Input_En;     //ʹ
} PORT_InitTypeDef;


typedef enum
{ 
	WAKEUP_EDGE_FALL =  0x00,    // ½ػ
	WAKEUP_EDGE_RISE =  0x01,    // ػ
} WakeUpEdge_TypeDef;

typedef enum
{ 
	PULLUP_RES_OPEN =  0x00,     // ·
	PULLUP_RES_150K =  0x01,     // 150K
	PULLUP_RES_40K =   0x02,     // 40K
	PULLUP_RES_32K =   0x03,     // 32K	
} PullUpRes_TypeDef;

typedef enum
{ 
	OUT_CURRENT_5MA  =  0x00,    // 5MA
	OUT_CURRENT_14MA =  0x01,    // 14MA
	OUT_CURRENT_22MA =  0x02,    // 22MA
	OUT_CURRENT_30MA =  0x03,    // 30MA
} OutCurrent_TypeDef;

typedef enum
{ 
	INPUT_HYS_LOW =   0x00,      //   
	INPUT_HYS_HIGH =  0x01,      //   
} InputHys_TypeDef;

#ifdef IC_BL2101
typedef struct
{
	WakeUpEdge_TypeDef   WakeUp_Edge;            //PORTA PORTBĻ
	PullUpRes_TypeDef    PullUp_Res;             //PORTA PORTB
	OutCurrent_TypeDef   Out_Cur_A0_7;           //PORTA0-A7
	OutCurrent_TypeDef   Out_Cur_A8_15;          //PORTA8-A15
	OutCurrent_TypeDef   Out_Cur_B0_7;           //PORTB0-B7
	InputHys_TypeDef     InputHys;               //PORTA PORTB͵ȼ
}PORT_CFGTypeDef;
#endif

#ifdef IC_BL2102
typedef struct
{
	WakeUpEdge_TypeDef   WakeUp_Edge;            //PORTAĻ
	PullUpRes_TypeDef    PullUp_Res;             //PORTA
	OutCurrent_TypeDef   Out_Cur;                //PORTA
	InputHys_TypeDef     InputHys;               //PORTA͵ȼ
}PORT_CFGTypeDef;
#endif

#define GPIO_PIN0                  0             //0
#define GPIO_PIN1                  1             //1
#define GPIO_PIN2                  2             //2
#define GPIO_PIN3                  3             //3
#define GPIO_PIN4                  4             //4
#define GPIO_PIN5                  5             //5
#define GPIO_PIN6                  6             //6
#define GPIO_PIN7                  7             //7
#define GPIO_PIN8                  8             //8
#define GPIO_PIN9                  9             //9
#define GPIO_PIN10                 10            //10
#define GPIO_PIN11                 11            //11
#define GPIO_PIN12                 12            //12
#define GPIO_PIN13                 13            //13
#define GPIO_PIN14                 14            //14
#define GPIO_PIN15                 15            //15

#define PORTA	                   0             //˿A
#define PORTB	                   1             //˿B

#ifdef IC_BL2101
#define PORTA_PIN0_GPIO		 	   0             //PORTA0ΪGPIOA0
#define PORTA_PIN0_UART0_TX        1             //PORTA0Ϊ0ķ
#define PORTA_PIN0_IIC_SCL	       2             //PORTA0ΪIICʱ

#define PORTA_PIN1_GPIO			   0             //PORTA1ΪGPIOA1
#define PORTA_PIN1_UART0_RX        1             //PORTA0Ϊ0Ľ
#define PORTA_PIN1_IIC_SDA	       2             //PORTA0ΪIIC

#define PORTA_PIN2_GPIO			   0             //PORTA2ΪGPIOA2
#define PORTA_PIN2_SPI_SSN	       1             //PORTA2ΪSPIƬѡ

#define PORTA_PIN3_GPIO			   0             //PORTA3ΪGPIOA3
#define PORTA_PIN3_SPI_SCLK	       1             //PORTA3ΪSPIʱ

#define PORTA_PIN4_GPIO			   0             //PORTA4ΪGPIOA4
#define PORTA_PIN4_SPI_MOSI	       1             //PORTA4ΪSPI

#define PORTA_PIN5_GPIO			   0             //PORTA5ΪGPIOA5
#define PORTA_PIN5_SPI_MISO	       1             //PORTA5ΪSPIӳ

#define PORTA_PIN6_GPIO			   0             //PORTA6ΪGPIOA6
#define PORTA_PIN6_PWM0		       1             //PORTA6ΪPWM0ͨ
#define PORTA_PIN6_UART1_TX        2             //PORTA6Ϊ1ķ
#define PORTA_PIN6_ADC_CH7	       3             //PORTA6ΪADCͨ7

#define PORTA_PIN7_GPIO			   0             //PORTA7ΪGPIOA7
#define PORTA_PIN7_PWM1     	   1             //PORTA7ΪPWM1ͨ
#define PORTA_PIN7_UART1_RX        2             //PORTA7Ϊ1Ľ
#define PORTA_PIN7_ADC_CH6	       3             //PORTA7ΪADCͨ6

#define PORTA_PIN8_GPIO		 	   0             //PORTA8ΪGPIOA8
#define PORTA_PIN8_PWM4	           1             //PORTA8ΪPWM4ͨ
#define PORTA_PIN8_ADC_CH7	       3             //PORTA8?????aADC?̨7
 
#define PORTA_PIN9_GPIO			   0             //PORTA9ΪGPIOA9
#define PORTA_PIN9_SWCLK	       1             //PORTA9ΪSWصʱ
#define PORTA_PIN9_UART0_TX        2             //PORTA9Ϊ0ķ

#define PORTA_PIN10_GPIO		   0             //PORTA10ΪGPIOA10
#define PORTA_PIN10_SWDIO		   1             //PORTA10ΪSWص
#define PORTA_PIN10_UART0_RX       2             //PORTA10Ϊ0Ľ

#define PORTA_PIN11_GPIO		   0             //PORTA11ΪGPIOA11
#define PORTA_PIN11_PWM0		   1             //PORTA11ΪPWM0ͨ

#define PORTA_PIN12_GPIO		   0             //PORTA12ΪGPIOA12
#define PORTA_PIN12_PWM1		   1             //PORTA12ΪPWM1ͨ
#define PORTA_PIN12_UART2_TX       2             //PORTA12Ϊ2ķ

#define PORTA_PIN13_GPIO		   0             //PORTA13ΪGPIOA13
#define PORTA_PIN13_PWM2	       1             //PORTA13ΪPWM2ͨ
#define PORTA_PIN13_UART2_RX       2             //PORTA13Ϊ2Ľ

#define PORTA_PIN14_GPIO		   0             //PORTA14ΪGPIOA14
#define PORTA_PIN14_PWM3	       1             //PORTA14ΪPWM3ͨ
#define PORTA_PIN14_IIC_SCL	       2             //PORTA14ΪIICʱ

#define PORTA_PIN15_GPIO		   0             //PORTA15ΪGPIOA15
#define PORTA_PIN15_PWM4	       1             //PORTA15ΪPWM4ͨ
#define PORTA_PIN15_IIC_SDA	       2             //PORTA15ΪIIC
#endif

#ifdef IC_BL2102
#define PORTA_PIN0_GPIO		 	   0             //PORTA0ΪGPIOA0
#define PORTA_PIN0_SPI_CLK         1             //PORTA0ΪSPIʱ
#define PORTA_PIN0_TMRP0_IN0       2             //PORTA0ΪTIMER_PLUS0
#define PORTA_PIN0_TMRP0_OUT_L     3             //PORTA0ΪTIMER_PLUS16λʱ
#define PORTA_PIN0_PWMB0_CH0       4             //PORTA0ΪPWMBASE0ͨ0
#define PORTA_PIN0_PWMP0_CH0N      5             //PORTA0ΪPWMPLUS0ͨ0N


#define PORTA_PIN1_GPIO			   0             //PORTA1ΪGPIOA1
#define PORTA_PIN1_SPI_MOSI	       1             //PORTA1ΪSPI
#define PORTA_PIN1_UART0_TX        2             //PORTA1Ϊ0ķ
#define PORTA_PIN1_HALL_IN0        3             //PORTA1ΪHALLͨ0
#define PORTA_PIN1_PWMP0_CH1N      4             //PORTA1ΪPWMPLUS0ͨ1N
#define PORTA_PIN1_ADC_CH1	       7             //PORTA1ΪADCͨ1


#define PORTA_PIN2_GPIO			   0             //PORTA2ΪGPIOA2
#define PORTA_PIN2_SPI_MISO	       1             //PORTA2ΪSPIӳ
#define PORTA_PIN2_UART0_RX        2             //PORTA2Ϊ0Ľ
#define PORTA_PIN2_HALL_IN1        3             //PORTA2ΪHALLͨ1
#define PORTA_PIN2_PWMP0_CH2N      4             //PORTA2ΪPWMPLUS0ͨ2N
#define PORTA_PIN2_ADC_CH0	       7             //PORTA2ΪADCͨ0


#define PORTA_PIN3_GPIO			   0             //PORTA3ΪGPIOA3
#define PORTA_PIN3_IIC_SDA	       1             //PORTA3ΪIIC
#define PORTA_PIN3_PWMP0_CH0       2             //PORTA3ΪPWMPLUS0ͨ0
#define PORTA_PIN3_XTAH_IN         7             //PORTA3ΪXTAH_IN


#define PORTA_PIN4_GPIO			   0             //PORTA4ΪGPIOA4
#define PORTA_PIN4_IIC_SCL	       1             //PORTA4ΪIICʱ
#define PORTA_PIN4_PWMP0_CH1       2             //PORTA4ΪPWMPLUS0ͨ1
#define PORTA_PIN4_XTAH_OUT        7             //PORTA4ΪXTAH_OUT


#define PORTA_PIN5_GPIO			   0             //PORTA5ΪGPIOA5
#define PORTA_PIN5_SPI_SSN	       1             //PORTA5ΪSPIƬѡ
#define PORTA_PIN5_TMRP0_IN1       2             //PORTA5ΪTIMER_PLUS1
#define PORTA_PIN5_TMRP0_OUT_H     3             //PORTA5ΪTIMER_PLUS16λʱ
#define PORTA_PIN5_PWMB0_CH1       4             //PORTA5ΪPWMBASE0ͨ1
#define PORTA_PIN5_PWMP0_CH2       5             //PORTA5ΪPWMPLUS0ͨ2
#define PORTA_PIN5_ADC_CH7	       7             //PORTA5ΪADCͨ7


#define PORTA_PIN6_GPIO			   0             //PORTA6ΪGPIOA6
#define PORTA_PIN6_IIC_SDA	       1             //PORTA6ΪIIC
#define PORTA_PIN6_BREAK_IN0       3             //PORTA6ΪBREAK_IN0
#define PORTA_PIN6_ADC_CH6	       7             //PORTA6ΪADCͨ6


#define PORTA_PIN7_GPIO			   0             //PORTA7ΪGPIOA7
#define PORTA_PIN7_IIC_SCL	       1             //PORTA7ΪIICʱ
#define PORTA_PIN7_BREAK_IN1       2             //PORTA7ΪBREAK_IN1
#define PORTA_PIN7_HALL_IN2        3             //PORTA7ΪHALLͨ2
#define PORTA_PIN7_ADC_CH5	       7             //PORTA7ΪADCͨ5


#define PORTA_PIN8_GPIO		 	   0             //PORTA8ΪGPIOA8
#define PORTA_PIN8_UART0_TX        1             //PORTA8Ϊ0ķ
#define PORTA_PIN8_TMRP0_IN0       2             //PORTA8ΪTIMER_PLUS0
#define PORTA_PIN8_TMRP0_OUT_L     3             //PORTA8ΪTIMER_PLUS16λʱ
#define PORTA_PIN8_PWMP0_CH2       4             //PORTA8ΪPWMPLUS0ͨ2
#define PORTA_PIN8_PWMP0_CH0N      5             //PORTA8ΪPWMPLUS0ͨ0N 
 
 
#define PORTA_PIN9_GPIO			   0             //PORTA9ΪGPIOA9
#define PORTA_PIN9_UART0_RX        1             //PORTA9Ϊ0Ľ
#define PORTA_PIN9_TMRP0_IN1       2             //PORTA9ΪTIMER_PLUS1
#define PORTA_PIN9_TMRP0_OUT_H     3             //PORTA9ΪTIMER_PLUS16λʱ
#define PORTA_PIN9_PWMB0_CH2       4             //PORTA9ΪPWMBASE0ͨ2
#define PORTA_PIN9_PWMP0_CH1N      5             //PORTA9ΪPWMPLUS0ͨ1N
#define PORTA_PIN9_ADC_CH4	       7             //PORTA9ΪADCͨ4


#define PORTA_PIN10_GPIO		   0             //PORTA10ΪGPIOA10
#define PORTA_PIN10_SPI_CLK	       1             //PORTA10ΪSPIʱ
#define PORTA_PIN10_TMRP0_IN0      2             //PORTA10ΪTIMER_PLUS0
#define PORTA_PIN10_TMRP0_OUT_L    3             //PORTA10ΪTIMER_PLUS16λʱ
#define PORTA_PIN10_PWMB0_CH0      4             //PORTA10ΪPWMBASE0ͨ0
#define PORTA_PIN10_PWMP0_CH2N     5             //PORTA10ΪPWMPLUS0ͨ2N


#define PORTA_PIN11_GPIO		   0             //PORTA11ΪGPIOA11
#define PORTA_PIN11_SPI_MOSI	   1             //PORTA11ΪSPI
#define PORTA_PIN11_TMRP0_IN1      2             //PORTA11ΪTIMER_PLUS1
#define PORTA_PIN11_TMRP0_OUT_H    3             //PORTA11ΪTIMER_PLUS16λʱ
#define PORTA_PIN11_PWMP0_CH0      4             //PORTA11ΪPWMPLUS0ͨ0


#define PORTA_PIN12_GPIO		   0             //PORTA12ΪGPIOA12
#define PORTA_PIN12_SPI_MISO	   1             //PORTA12ΪSPIӳ
#define PORTA_PIN12_TMRP0_IN0      2             //PORTA12ΪTIMER_PLUS0
#define PORTA_PIN12_TMRP0_OUT_L    3             //PORTA12ΪTIMER_PLUS16λʱ
#define PORTA_PIN12_PWMP0_CH1      4             //PORTA12ΪPWMPLUS0ͨ1


#define PORTA_PIN13_GPIO		   0             //PORTA13ΪGPIOA13
#define PORTA_PIN13_SWCLK		   1             //PORTA13ΪSWصʱ
#define PORTA_PIN13_PWMP0_CH2      2             //PORTA13ΪPWMPLUS0ͨ2


#define PORTA_PIN14_GPIO		   0             //PORTA14ΪGPIOA14
#define PORTA_PIN14_SWDIO		   1             //PORTA14ΪSWص
#define PORTA_PIN14_TMRP0_IN1      2             //PORTA14ΪTIMER_PLUS1
#define PORTA_PIN14_TMRP0_OUT_H    3             //PORTA14ΪTIMER_PLUS16λʱ
#define PORTA_PIN14_PWMB0_CH1      4             //PORTA14ΪPWMBASE0ͨ1
#define PORTA_PIN14_ADC_CH3	       7             //PORTA14ΪADCͨ3


#define PORTA_PIN15_GPIO		   0             //PORTA15ΪGPIOA15
#define PORTA_PIN15_SPI_SSN	       1             //PORTA15ΪSPIƬѡ
#define PORTA_PIN15_TMRP0_IN0      2             //PORTA15ΪTIMER_PLUS0
#define PORTA_PIN15_TMRP0_OUT_L    3             //PORTA15ΪTIMER_PLUS16λʱ
#define PORTA_PIN15_PWMB0_CH2      4             //PORTA15ΪPWMBASE0ͨ2
#define PORTA_PIN15_ADC_CH2	       7             //PORTA15ΪADCͨ2

#endif

#define PORTB_PIN0_GPIO		 	   0             //PORTB0ΪGPIOB0
#define PORTB_PIN0_UART1_TX        1             //PORTB0Ϊ1ķ
#define PORTB_PIN0_IIC_SCL	       2             //PORTB0ΪIICʱ
#define PORTB_PIN0_ADC_CH5	       3             //PORTB0ΪADCͨ5

#define PORTB_PIN1_GPIO			   0             //PORTB1ΪGPIOB1
#define PORTB_PIN1_UART1_RX        1             //PORTB1Ϊ1Ľ
#define PORTB_PIN1_IIC_SDA	       2             //PORTB1ΪIIC
#define PORTB_PIN1_ADC_CH4	       3             //PORTB1ΪADCͨ4

#define PORTB_PIN2_GPIO			   0             //PORTB2ΪGPIOB2
#define PORTB_PIN2_SPI_MISO	       1             //PORTB2ΪSPIӳ
#define PORTB_PIN2_ADC_CH3	       3             //PORTB2ΪADCͨ3

#define PORTB_PIN3_GPIO			   0             //PORTB3ΪGPIOB3
#define PORTB_PIN3_SPI_MOSI	       1             //PORTB3ΪSPI
#define PORTB_PIN3_ADC_CH2	       3             //PORTB3ΪADCͨ2

#define PORTB_PIN4_GPIO			   0             //PORTB4ΪGPIOB4
#define PORTB_PIN4_SPI_CLK		   1             //PORTB4ΪSPIʱ
#define PORTB_PIN4_ADC_CH1	       3             //PORTB4ΪADCͨ1

#define PORTB_PIN5_GPIO			   0             //PORTB5ΪGPIOB5
#define PORTB_PIN5_SPI_SSN		   1             //PORTB5ΪSPIƬѡ
#define PORTB_PIN5_ADC_CH0	       3             //PORTB5ΪADCͨ0

#define PORTB_PIN6_GPIO			   0             //PORTB6ΪGPIOB6
#define PORTB_PIN6_PWM2	           1             //PORTB6ΪPWM2ͨ
#define PORTB_PIN6_UART2_TX        2             //PORTB6Ϊ2ķ

#define PORTB_PIN7_GPIO			   0             //PORTB7ΪGPIOB7
#define PORTB_PIN7_PWM3            1             //PORTB7ΪPWM3ͨ
#define PORTB_PIN7_UART2_RX        2             //PORTB7Ϊ2Ľ




void PORT_Init(PORT_InitTypeDef* PORT_InitStruct);               //PORTʼ
void PORT_CFG_Init(PORT_CFGTypeDef* PORT_CFGStruct);             //PORTüĴ

#endif //__BL210x_PORT_H__
