#ifndef __BL2101_UART_H__
#define __BL2101_UART_H__

#include "BL210x.h"


typedef enum
{ 
	UART_DATA_5BIT =  0x00,       //λ5bit
	UART_DATA_6BIT =  0x01,       //λ6bit
    UART_DATA_7BIT =  0x02,       //λ7bit
	UART_DATA_8BIT =  0x03        //λ8bit
} DataBits_TypeDef;

typedef enum
{ 
	UART_PARITY_NONE =  0x00,     //У
	UART_PARITY_ODD  =  0x01,     //У
    UART_PARITY_EVEN =  0x03,     //żУ
	UART_PARITY_ONE  =  0x05,     //1
	UART_PARITY_ZERO =  0x07      //0
} Parity_TypeDef;

typedef enum
{ 
	UART_STOP_1BIT =  0x00,       //1λֹͣλ
	UART_STOP_2BIT =  0x01,       //2λֹͣλ
} StopBits_TypeDef;


typedef struct {
	uint32_t          Baudrate;         //
	
	DataBits_TypeDef  DataBits;			//λλȡֵUART_DATA_5BITUART_DATA_6BIT  UART_DATA_7BITUART_DATA_8BIT
	
	Parity_TypeDef    Parity;			//żУλȡֵUART_PARITY_NONEUART_PARITY_ODDUART_PARITY_EVENUART_PARITY_ONEUART_PARITY_ZERO
	
	StopBits_TypeDef  StopBits;			//ֹͣλλȡֵUART_STOP_1BITUART_STOP_2BIT
	
	uint8_t           RXIEn;	        //Чж
} UART_InitTypeDef;


#define UART_ERR_REC        1            //ݴ
#define UART_ERR_OVF        2            //
#define UART_ERR_PARITY     3            //У
#define UART_ERR_STOP       4            //ֹͣλ
#define UART_ERR_BREAK      5            //BREAK


#define UART_RIID_THRE      2            //ݼĴжϱ־
#define UART_RIID_REC       4            //Ч

void UART_Init(UART_TypeDef * UARTx, UART_InitTypeDef * initStruct);	//UARTڳʼ
void UART_SendData(UART_TypeDef * UARTx, uint8_t data);                 //ڷ
uint8_t UART_ReceiveData(UART_TypeDef * UARTx, uint8_t *data);          //ڽ
uint8_t UART_IsTXEmpty(UART_TypeDef * UARTx);                           //ڷͿж
uint8_t UART_IsRXValid(UART_TypeDef * UARTx);                           //ڽЧж


#endif //__BL2101_UART_H__
